% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdditionTree.R
\name{AdditionTree}
\alias{AdditionTree}
\title{Addition tree}
\usage{
AdditionTree(dataset, concavity = Inf, constraint, sequence)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.
Perhaps load into R using \code{\link[TreeTools]{ReadAsPhyDat}}.
Additive (ordered) characters can be handled using
\code{\link[TreeTools]{Decompose}}.}

\item{concavity}{Determines the degree to which extra steps beyond the first
are penalized.  Specify a numeric value to use implied weighting
\insertCite{Goloboff1993}{TreeSearch}; \code{concavity} specifies \emph{k} in
\emph{k} / \emph{e} + \emph{k}. A value of 10 is recommended;
TNT sets a default of 3, but this is too low in some circumstances
\insertCite{Goloboff2018,Smith2019}{TreeSearch}.
Better still explore the sensitivity of results under a range of
concavity values, e.g. \code{k = 2 ^ (1:7)}.
Specify \code{Inf} to weight each additional step equally,
(which underperforms step weighting approaches
\insertCite{Goloboff2008,Goloboff2018,Goloboff2019,Smith2019}{TreeSearch}).
Specify \code{"profile"} to employ an approximation of profile parsimony
\insertCite{Faith2001}{TreeSearch}.}

\item{constraint}{Either an object of class \code{phyDat}, in which case
returned trees will be perfectly compatible with each character in
\code{constraint}; or a tree of class \code{phylo}, all of whose nodes will occur
in any output tree.
See \code{\link[TreeTools:ImposeConstraint]{ImposeConstraint()}} and
\href{https://ms609.github.io/TreeSearch/articles/tree-search.html}{vignette}
for further examples.}

\item{sequence}{Character or numeric vector listing sequence in which to add
taxa. Randomized if not provided.}
}
\value{
\code{AdditionTree()} returns a tree of class \code{phylo}, rooted on
\code{sequence[1]}.
}
\description{
Generates a starting tree by adding each taxon in turn to the most
parsimonious location.
}
\examples{
data("inapplicable.phyData", package = "TreeSearch")
AdditionTree(inapplicable.phyData[["Longrich2010"]], concavity = 10)
}
\seealso{
Impose a constraint: \href{https://ms609.github.io/TreeTools/reference/ImposeConstraint}{\code{TreeTools::ImposeConstraint()}}

Neighbour-joining trees: \href{https://ms609.github.io/TreeTools/reference/NJTree.html}{\code{TreeTools::NJTree()}};
\href{https://ms609.github.io/TreeTools/reference/ConstrainedNJ}{\code{TreeTools::ConstrainedNJ()}}

Other tree generation functions: 
\code{\link{RandomMorphyTree}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
