% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PreviousDate}
\alias{PreviousDate}
\alias{add_prev_date}
\alias{get_prev_date}
\title{Find Previous Test Date for Subject}
\usage{
add_prev_date(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result"
)

get_prev_date(
  object,
  subject = "subject",
  timepoint = "timepoint",
  result = "result"
)
}
\arguments{
\item{object}{a \code{\link{data.frame}} (or object coercible by \code{\link{as.data.frame}()} to
a data frame) containing the data to be analysed.}

\item{subject}{\code{\link{character}}, name of the column (of type \code{\link{integer}} or
\code{\link{factor}}) identifying individual study subjects; default \code{"subject"}.}

\item{timepoint}{\code{character}, name of the column recording time points (as \code{\link{Dates}})
of testing of subjects; default \code{"timepoint"}.}

\item{result}{\code{character}, name of the column (of type \code{\link[base:factor]{ordered factor}})
recording test results; default \code{"result"}.}
}
\value{
\item{\code{add_prev_date()}}{A \code{\link{data.frame}} based on \code{object}, with an added
   column of class \code{\link{Date}} containing the values of the previous test dates.}

\item{\code{get_prev_date()}}{An \code{vector} of length \code{\link{nrow}(object)},
   class \code{\link{Date}}, containing the values of the previous test dates ordered in the exact
   sequence of the \code{subject} and \code{timepoint} in \code{object}.}
}
\description{
\code{get_prev_dates()} identifies the previous test date for individual subjects and timepoints
in a longitudinal study.

\code{add_prev_date()} interpolates these previous test dates into a data frame for further analysis.
}
\details{
See \code{\link{Transitions}} \emph{details}.
}
\examples{

\dontshow{
Blackmore <- transform(Blackmore, timepoint = as.Date("2000-01-01") + round(age * 365.25),
    result = cut(exercise, breaks = seq(0, 30, 2), labels = paste0("<=", seq(0, 30, 2)[-1]),
        include.lowest = TRUE, ordered_result = TRUE))
}

 ## Continuing example from `add_transitions()`
  # subject, timepoint and result arguments all defaults and required types
Blackmore |> str()

  # Integer vector of the previous test dates
get_prev_date(Blackmore)

  # Add column of  previous test dates to data frame
add_prev_date(Blackmore) |> head(32)

rm(Blackmore)

###
## Example on formatting numeric values as R dates

#  Data frame containing year as numeric: 2018 to 2025
(df <- data.frame(
    subject = rep(1001:1003),
    timepoint = rep(2018:2025, each = 3),
    result = gl(3, 4, lab = c("jolly", "good", "show"), ordered = TRUE)
    ))

#  Convert to R dates
df <- transform(df,
           timepoint = as.Date(paste(timepoint, "01", "01", sep = "-"))
      )

  # Add column of test result transitions (defaults: cap = 0, modulate = 0)
(df <- add_transitions(df))

# Format R dates just to show the year
transform(df, timepoint = format(timepoint, "\%Y"))

#  Data frame containing year and month as numeric: July 2024 to June 2025
(df <- data.frame(
           subject = 1001:1002,
           year = rep(2024:2025, each = 12),
           month = rep(c(7:12, 1:6), each = 2),
           result = gl(2, 3, lab = c("low", "high"), ordered = TRUE)
       ))

#  Convert to R dates
df <- transform(df, timepoint = as.Date(paste(year, month, "01", sep = "-")))
\dontshow{
    df$year <- NULL
    df$month <- NULL
}

  # Add column of test result transitions (defaults: cap = 0, modulate = 0)
(df <- add_transitions(df))

# Format R dates just to show the month and year
transform(df, timepoint = format(timepoint, "\%b-\%Y"))

rm(df)

}
\seealso{
\code{\link{data.frame}}, \code{\link{Dates}}, \code{\link[base:factor]{ordered factor}}.

Other transitions: 
\code{\link{PreviousResult}},
\code{\link{Transitions}},
\code{\link{uniques}()}
}
\concept{transitions}
