% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionalize.R
\name{regionalize}
\alias{regionalize}
\title{regionalize - Calculating regionalized TL-moments}
\usage{
regionalize(x, w = rep(1, ncol(x$lambdas)), reg.lambdas = TRUE)
}
\arguments{
\item{x}{object returned by TLMoments.matrix. TLMoments.list and
TLMoments.data.frame are not supported by now.}

\item{w}{numeric vector giving the weights. The function ensures
that it adds up to 1.}

\item{reg.lambdas}{logical, if TRUE (default) regionalization is
based upon TL-moments. If false it's based on TL-moment-ratios}
}
\value{
a list of two dimensions: \code{lambdas}/\code{ratios} are a matrix
consisting of the regionalized TL-moments/TL-moment-ratios. The list has
the class \code{TLMoments}. The object contains the following attributes: \itemize{
 \item \code{leftrim}: a numeric giving the used leftrim-argument
 \item \code{rightrim}: a numeric giving the used rightrim-argument
 \item \code{order}: a integer vector with corresponding TL-moment orders
 \item \code{computation.method} a character giving the used computation method
 \item \code{source}: a list with background information (used function, data,
 n, formula; mainly for internal purposes)
}
}
\description{
regionalize takes the result of TLMoments.matrix and calculates a weighted mean
of TL-moments and TL-moment ratios.
}
\examples{
tlm <- TLMoments(
  matrix(rgev(200, loc = 10, scale = 5, shape = .3), nc = 5),
  leftrim = 0, rightrim = 1)
regionalize(tlm)
parameters(regionalize(tlm), "gev")
quantiles(parameters(regionalize(tlm), "gev"), c(.99, .999))
quantiles(parameters(regionalize(tlm, reg.lambdas = FALSE), "gev"), c(.99, .999))

# With magrittr
library(magrittr)
matrix(rgev(200, shape = .3), nc = 5) \%>\%
 TLMoments(rightrim = 1) \%>\%
 regionalize \%>\%
 parameters("gev") \%>\%
 quantiles(c(.99, .999))
}
