% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{TCvectInterp}
\alias{TCvectInterp}
\title{Temporally Interpolate Along a Tropical Cyclone Track And Compute Along-Track Parameters}
\usage{
TCvectInterp(outdate = NULL, TC, paramsTable)
}
\arguments{
\item{outdate}{POSIX times to be interpolated to. The output date in "YYYY-MM-DD" format. Default is NULL.}

\item{TC}{SpatVector of Tropical cyclone track parameters}

\item{paramsTable}{Global parameters to compute TC Hazards.}
}
\value{
SpatVector of Tropical cyclone track parameters
}
\description{
Temporally Interpolate Along a Tropical Cyclone Track And Compute Along-Track Parameters
}
\examples{
require(terra)
TCi <- vect(system.file("extdata/YASI/YASI.shp", package="TCHazaRds"))
TCi$PRES <- TCi$BOM_PRES
TCi$PRES[is.na(TCi$PRES)] = 1010
outdate = seq(strptime(TCi$ISO_TIME[1],"\%Y-\%m-\%d \%H:\%M:\%S",tz="UTC"),
strptime(rev(TCi$ISO_TIME)[1],"\%Y-\%m-\%d \%H:\%M:\%S",tz="UTC"),3600)
paramsTable = read.csv(system.file("extdata/tuningParams/defult_params.csv",package = "TCHazaRds"))
TCii = TCvectInterp(outdate = outdate,TC=TCi,paramsTable = paramsTable)

}
