% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_anova.test.R
\name{p_anova.test}
\alias{p_anova.test}
\alias{gen_anova.test}
\title{p-value from one-way ANOVA simulation}
\usage{
p_anova.test(
  n,
  k,
  f,
  n.ratios = rep(1, k),
  two.tailed = TRUE,
  var.equal = TRUE,
  means = NULL,
  sds = NULL,
  gen_fun = gen_anova.test,
  return_analysis = FALSE,
  ...
)

gen_anova.test(n, k, f, n.ratios = rep(1, k), means = NULL, sds = NULL, ...)
}
\arguments{
\item{n}{sample size per group}

\item{k}{number of groups}

\item{f}{Cohen's f effect size}

\item{n.ratios}{allocation ratios reflecting the sample size ratios.
Default of 1 sets the groups to be the same size (n * n.ratio)}

\item{two.tailed}{logical; should a two-tailed or one-tailed test be used?}

\item{var.equal}{logical; use the pooled SE estimate instead of the Welch
correction for unequal variances?}

\item{means}{(optional) vector of means. When specified the input \code{f} is ignored}

\item{sds}{(optional) vector of SDs. When specified the input \code{f} is ignored}

\item{gen_fun}{function used to generate the required data.
Object returned must be a \code{matrix} with k rows and k columns of numeric data.
Default uses \code{\link{gen_anova.test}}.
User defined version of this function must include the argument \code{...}}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
Generates continuous multi-sample data to be analyzed by
a one-way ANOVA, and return a p-value.
Uses the function \code{\link{oneway.test}} to perform the analyses.
The data and associated
test assume that the conditional observations are normally distributed and have
have equal variance by default, however these may be modified.
}
\examples{

# n=50 in 3 groups, "medium" effect size
p_anova.test(50, k=3, f=.25)

# return analysis model
p_anova.test(50, k=3, f=.25, return_analysis=TRUE)

# explicit means/sds
p_anova.test(50, 3, means=c(0,0,1), sds=c(1,2,1))

\donttest{
  # compare simulated results to pwr package
  pwr::pwr.anova.test(f=0.28, k=4, n=20)
  p_anova.test(n=20, k=4, f=.28) |> Spower()
}

}
\seealso{
\code{\link{gen_anova.test}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
