% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSpatialCoor.R
\name{plotSpatialProp}
\alias{plotSpatialProp}
\title{Plot predicted proportions for a specific cell type using spatial coordinates
of spots}
\usage{
plotSpatialProp(
  object,
  index.st,
  cell.type,
  colors = "blues",
  set = "raw",
  prediction = "Regularized",
  limits = NULL,
  size.point = 1,
  title = NULL,
  theme = NULL
)
}
\arguments{
\item{object}{A \code{\linkS4class{SpatialDDLS}} object.}

\item{index.st}{Index of the spatial transcriptomics data to be plotted. It
can be either a position or a name if a named list of
\code{\link[SpatialExperiment]{SpatialExperiment}} objects was provided.}

\item{cell.type}{Cell type predicted proportions to color spots by.}

\item{colors}{Color scale to be used. It can be \code{"blues"} or
\code{"spectral"} (the former by default).}

\item{set}{If results were simplified (see \code{?\link{deconvSpatialDDLS}}
for details), what results to plot (\code{raw} by default).}

\item{prediction}{It can be \code{"Regularized"}, \code{"Intrinsic"} or
\code{"Extrinsic"} (\code{"Regularized"} by default).}

\item{limits}{A vector of two elements indicating wanted limits for color
scale. If \code{NULL} (by default), color scale is adjusted to max and min
predicted proportions.}

\item{size.point}{Size of points (0.1 by default).}

\item{title}{Title of plot.}

\item{theme}{\pkg{ggplot2} theme.}
}
\value{
A ggplot object.
}
\description{
Color spots on the spatial coordinates according to the predicted proportions
of a particular cell type. Color scale is adapted depending on the range of
predicted proportions.
}
\seealso{
\code{\link{plotSpatialPropAll}} \code{\link{deconvSpatialDDLS}}
\code{\link{trainDeconvModel}}
}
