% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SettingsObjects.R
\name{createControlIntervalSettings}
\alias{createControlIntervalSettings}
\title{Create control interval settings}
\usage{
createControlIntervalSettings(
  includeEraIds = NULL,
  excludeEraIds = NULL,
  start = 0,
  startAnchor = "era start",
  end = 0,
  endAnchor = "era end",
  firstOccurrenceOnly = FALSE
)
}
\arguments{
\item{includeEraIds}{One or more IDs of variables in the \link{SccsData} object that should be
used to construct this covariate. If no IDs are specified, all
variables will be used.}

\item{excludeEraIds}{One or more IDs of variables in the [SccsData] object that should not
be used to construct this covariate.}

\item{start}{The start of the control interval (in days) relative to the \code{startAnchor}.}

\item{startAnchor}{The anchor point for the start of the control interval. Can be \code{"era start"}
or \code{"era end"}.}

\item{end}{The end of the control interval (in days) relative to the \code{endAnchor}.}

\item{endAnchor}{The anchor point for the end of the control interval. Can be \code{"era start"}
or \code{"era end"}.}

\item{firstOccurrenceOnly}{Should only the first occurrence of the exposure be used?}
}
\value{
An object of type \code{ControlIntervalSettings}.
}
\description{
Create control interval settings
}
\details{
Create an object specifying how to create a control interval for the self-controlled risk interval (SCRI)
design.
}
