% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{pairwiseMatrix}
\alias{pairwiseMatrix}
\title{Pairwise plotting of multivariate data}
\usage{
pairwiseMatrix(x, y = NULL, size = nrow(x), r = 4, c = 4, ...)
}
\arguments{
\item{x}{A matrix or data.frame (n x p) of continuous data.}

\item{y}{A matrix or data.frame (n x q) of continuous data.}

\item{size}{number of rows to be sampled (default \code{size = nrow(x)}).}

\item{r}{number of rows of the plot layout (default \code{r = 4}).}

\item{c}{number of columns of the plot layout (default \code{c = 4}).}

\item{...}{Currently ignored.}
}
\value{
No return value
}
\description{
Display a pairwise scatter plot of two datasets for a
random selection of variables. If the second dataset is not given,
the function displays a histogram with normal curve superposition.
}
\examples{
adjdata <- SEMbap(sachs$graph, log(sachs$pkc))$data
rawdata <- log(sachs$pkc)
pairwiseMatrix(adjdata, rawdata, size = 1000)

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
