% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMhelp.R
\name{nplot}
\alias{nplot}
\title{Create a plot for a neural network model}
\usage{
nplot(dnn.fit, bias = FALSE, ...)
}
\arguments{
\item{dnn.fit}{A neural network model from \pkg{cito} R package.}

\item{bias}{A logical value, indicating whether to draw biases in 
the layers (default = FALSE).}

\item{...}{Currently ignored.}
}
\value{
The function invisibly returns the graphical object representing
the neural network architecture designed by NeuralNetTools.
}
\description{
The function draws a neural network plot as a neural
interpretation diagram using with the \code{\link[NeuralNetTools]{plotnet}}
function of the \pkg{NeuralNetTools} R package.
}
\details{
The induced subgraph of the input graph mapped on data 
variables. Based on the estimated connection weights, if the connection
weight W > 0, the connection is activated and it is highlighted in red;  
if W < 0, the connection is inhibited and it is highlighted in blue.
}
\examples{

\donttest{
if (torch::torch_is_installed()){

# load ALS data
ig<- alsData$graph
data<- alsData$exprs
data<- transformData(data)$data

#ncores<- parallel::detectCores(logical = FALSE)
dnn0 <- SEMdnn(ig, data, train=1:nrow(data), grad = FALSE,
			#hidden = 5*K, link = "selu", bias = TRUE,
			hidden = c(10, 10, 10), link = "selu", bias =TRUE,
			validation = 0, epochs = 32, ncores = 2)

 for (j in 1:length(dnn0$model)) {
   nnj <- dnn0$model[[j]][[1]]
   nplot(nnj)
   Sys.sleep(5)
 }
}
}

}
\references{
Beck, M.W. 2018. NeuralNetTools: Visualization and Analysis Tools for Neural 
Networks. Journal of Statistical Software. 85(11):1-20.
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
