% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.MBCn.R
\name{MBCn}
\alias{MBCn}
\title{MBCn (Multivariate Bias Correction)}
\description{
Perform a multivariate bias correction.
}
\details{
BC is performed with an alternance of rotation and univariate BC.
}
\examples{
## Three bivariate random variables (rnorm and rexp are inverted between ref
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(200)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period
X1 = XY$X1 ## Biased in projection period

## Bias correction
## Step 1 : construction of the class MBCn
mbcn = SBCK::MBCn$new() 
## Step 2 : Fit the bias correction model
mbcn$fit( Y0 , X0 , X1 )
## Step 3 : perform the bias correction, Z is a list containing
## corrections
Z = mbcn$predict(X1,X0) 
Z$Z0 ## Correction in calibration period
Z$Z1 ## Correction in projection period

}
\references{
Cannon, A. J., Sobie, S. R., and Murdock, T. Q.: Bias correction
            of simulated precipitation by quantile mapping: how well do
            methods preserve relative changes in quantiles and extremes?, J.
            Climate, 28, 6938–6959,
            https://doi.org/10.1175/JCLI-D-14- 00754.1, 2015.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n_features}}{[integer] Numbers of features}

\item{\code{bc}}{[BC class] Univariate BC method}

\item{\code{metric}}{[function] distance between two datasets}

\item{\code{iter_slope}}{[Stopping class criteria] class used to test when stop}

\item{\code{bc_params}}{[list] Parameters of bc}

\item{\code{ortho_mat}}{[array] Array of orthogonal matrix}

\item{\code{tips}}{[array] Array which contains the product of ortho and inverse
of next}

\item{\code{lbc}}{[list] list of BC method used.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MBCn-new}{\code{MBCn$new()}}
\item \href{#method-MBCn-fit}{\code{MBCn$fit()}}
\item \href{#method-MBCn-predict}{\code{MBCn$predict()}}
\item \href{#method-MBCn-clone}{\code{MBCn$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MBCn-new"></a>}}
\if{latex}{\out{\hypertarget{method-MBCn-new}{}}}
\subsection{Method \code{new()}}{
Create a new MBCn object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MBCn$new(
  bc = QDM,
  metric = wasserstein,
  stopping_criteria = SlopeStoppingCriteria,
  stopping_criteria_params = list(minit = 20, maxit = 100, tol = 0.001),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bc}}{[BC class] Univariate bias correction method}

\item{\code{metric}}{[function] distance between two datasets}

\item{\code{stopping_criteria}}{[Stopping class criteria] class use to test when
to stop the iterations}

\item{\code{stopping_criteria_params}}{[list] parameters passed to
stopping_criteria class}

\item{\code{...}}{[] Others arguments passed to bc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `MBCn` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MBCn-fit"></a>}}
\if{latex}{\out{\hypertarget{method-MBCn-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MBCn$fit(Y0, X0, X1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}

\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MBCn-predict"></a>}}
\if{latex}{\out{\hypertarget{method-MBCn-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MBCn$predict(X1, X0 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X1}}{[matrix: n_samples * n_features] Model in projection}

\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix or list] Return the matrix of correction of X1 if X0 is
                         NULL, else return a list containing Z1 and Z0,
                         the corrections of X1 and X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MBCn-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MBCn-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MBCn$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
