% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetry_plot.R
\name{symmetry_plot}
\alias{symmetry_plot}
\title{symmetry_plot}
\usage{
symmetry_plot(
  df,
  var_name,
  position = position_jitter(width = 0, height = 0),
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = "V",
  y_title = "U",
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  x_limits = NULL,
  x_major_breaks = waiver(),
  x_minor_breaks = waiver(),
  x_labels = waiver(),
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  x_y_decimals = NULL,
  x_y_scientific = NULL,
  axis_text_size = 11,
  pts_fill = "black",
  pts_shape = 21,
  pts_stroke = 1,
  pts_color = "black",
  pts_size = 1,
  pts_alpha = 1,
  line_width = 0.6,
  line_color = "blue",
  line_alpha = 0.7,
  line_linetype = "solid",
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  panel_color = "white",
  panel_border_color = "black"
)
}
\arguments{
\item{df}{The target data frame from which the distance from the median are plotted.}

\item{var_name}{A string that sets the variable name of interest from 'df'. This is a required parameter.}

\item{position}{A string or function that does a slight adjustment to overlapping points.  Typical values are
"jitter" or \code{position_jitter(width = 0.1, height = 0.1)}.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default) then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if \code{TRUE} rotates the y tic labels 90 degrees for enhanced readability.}

\item{x_limits}{Sets the minimum and maximum for the x axis.}

\item{x_major_breaks}{A numeric vector or function that defines
the exact major tic locations along the x axis.}

\item{x_minor_breaks}{A numeric vector or function that defines
the exact minor tic locations along the x axis.}

\item{x_labels}{A character vector with the same length as 'x_major_breaks', that labels the major tics.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and maximum for the y axis.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_labels}{A character vector with the same length as 'y_major_breaks', that labels the major tics.}

\item{x_y_decimals}{A two element numeric vector that set the number of decimals for the x and y tic labels.}

\item{x_y_scientific}{A two element logical vector that if \code{TRUE} uses scientific notation for the x and y tic labels.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{pts_fill}{A string that sets the fill color attribute of the points.}

\item{pts_shape}{A numeric integer that sets the shape attribute of the points. Typical values are 21 "circle",
22 "square", 23 "diamond", 24 "up triangle", 25 "down triangle".}

\item{pts_stroke}{A numeric that sets the drawing stroke  width attribute for a point shape.}

\item{pts_color}{A string that sets the color attribute of the points.}

\item{pts_size}{A numeric value that sets the size attribute of the points.}

\item{pts_alpha}{A numeric value that sets the alpha level attribute of points.}

\item{line_width}{A numeric value that sets the width of the symmetry line.}

\item{line_color}{A string that sets the color of the symmetry line.}

\item{line_alpha}{A numeric that sets the alpha of the symmetry line.}

\item{line_linetype}{A string that sets the symmetry line type "twodash", "solid", "longdash", "dotted", "dotdash",
"dashed", "blank".}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}
}
\value{
A ggplot class plot object
}
\description{
Function creates a ggplot2 based symmetry plot from a vector of numeric values.

Function orders the numeric vector from low to high. It then divides the data into two groups: values above
the median(u group) and values below the median(v group). The distances from the median for values
in each group are computed. A scatter plot is created where distances in the v group are plotted along
the x axis and distances from the v group are plotted along the y axis. If the upper and lower distance
data forms a straight line then the original data is perfectly symmetrical.

A reference symmetry line is also drawn. If points fall close to the line then the data is nearly
symmetric. If the data is left-skewed, then the points fall below the line. If the data is right
skewed, the points fall above the line.

Function returns a ggplot2 plot object of x/y scatter point distances from the median. Options are provided
for axis scaling and point labeling.
}
\examples{
library(ggplot2)
library(RplotterPkg)

RplotterPkg::symmetry_plot(
  df = RplotterPkg::farms,
  var_name = "count",
  title = "Symmetry in farm counts across US states",
  rot_y_tic_label = TRUE,
  line_linetype = "dotted"
)

}
