% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artmap.R
\name{artmap}
\alias{artmap}
\alias{artmap.default}
\title{Create and train an artmap network}
\usage{
artmap(x, ...)

\method{artmap}{default}(
  x,
  nInputsTrain,
  nInputsTargets,
  nUnitsRecLayerTrain,
  nUnitsRecLayerTargets,
  maxit = 1,
  nRowInputsTrain = 1,
  nRowInputsTargets = 1,
  nRowUnitsRecLayerTrain = 1,
  nRowUnitsRecLayerTargets = 1,
  initFunc = "ARTMAP_Weights",
  initFuncParams = c(1, 1, 1, 1, 0),
  learnFunc = "ARTMAP",
  learnFuncParams = c(0.8, 1, 1, 0, 0),
  updateFunc = "ARTMAP_Stable",
  updateFuncParams = c(0.8, 1, 1, 0, 0),
  shufflePatterns = TRUE,
  ...
)
}
\arguments{
\item{x}{a matrix with training inputs and targets for the network}

\item{...}{additional function parameters (currently not used)}

\item{nInputsTrain}{the number of columns of the matrix that are training input}

\item{nInputsTargets}{the number of columns that are target values}

\item{nUnitsRecLayerTrain}{number of units in the recognition layer of the training data ART network}

\item{nUnitsRecLayerTargets}{number of units in the recognition layer of the target data ART network}

\item{maxit}{maximum of iterations to perform}

\item{nRowInputsTrain}{number of rows the training input units are to be organized in (only for visualization purposes of the net in the original SNNS software)}

\item{nRowInputsTargets}{same, but for the target value input units}

\item{nRowUnitsRecLayerTrain}{same, but for the recognition layer of the training data ART network}

\item{nRowUnitsRecLayerTargets}{same, but for the recognition layer of the target data ART network}

\item{initFunc}{the initialization function to use}

\item{initFuncParams}{the parameters for the initialization function}

\item{learnFunc}{the learning function to use}

\item{learnFuncParams}{the parameters for the learning function}

\item{updateFunc}{the update function to use}

\item{updateFuncParams}{the parameters for the update function}

\item{shufflePatterns}{should the patterns be shuffled?}
}
\value{
an \code{\link{rsnns}} object. The \code{fitted.values} member of the object contains a 
list of two-dimensional activation patterns.
}
\description{
An ARTMAP performs supervised learning. It consists of two coupled ART networks.
In theory, these could be ART1, ART2, or others. However, in SNNS ARTMAP is
implemented for ART1 only. So, this function is to be used with binary input. 
As explained in the description of \code{\link{art1}}, ART aims at solving the stability/plasticity
dilemma. So the advantage of ARTMAP is that it is a supervised learning mechanism
that guarantees stability.
}
\details{
See also the details section of \code{\link{art1}}. The two ART1 networks are connected by a \emph{map field}.
The input of the first ART1 network is the training input, the input of the second network are the target values, 
the teacher signals. The two networks are often called ARTa and ARTb, we call them here training data network 
and target data network.  

In analogy to the ART1 and ART2 implementations, there are one initialization function, one learning function, 
and two update functions present that are suitable for ARTMAP. The parameters are basically as in ART1, but for 
two networks. The learning function and the update functions have 3 parameters, the vigilance parameters of the 
two ART1 networks and an additional vigilance parameter for inter ART reset control. The initialization function
has four parameters, two for every ART1 network.

A detailed description of the theory and the parameters is available from 
the SNNS documentation and the other referenced literature.
}
\examples{
\dontrun{demo(artmap_letters)}
\dontrun{demo(artmap_lettersSnnsR)}


data(snnsData)
trainData <- snnsData$artmap_train.pat
testData <- snnsData$artmap_test.pat

model <- artmap(trainData, nInputsTrain=70, nInputsTargets=5, 
                  nUnitsRecLayerTrain=50, nUnitsRecLayerTargets=26)
model$fitted.values

predict(model, testData)
}
\references{
Carpenter, G. A.; Grossberg, S. & Reynolds, J. H. (1991), 'ARTMAP: Supervised real-time learning and classification of nonstationary data by a self-organizing neural network', Neural Networks 4(5), 565--588.

Grossberg, S. (1988), Adaptive pattern classification and universal recoding. I.: parallel development and coding of neural feature detectors, MIT Press, Cambridge, MA, USA, chapter I, pp. 243--258.

Herrmann, K.-U. (1992), 'ART -- Adaptive Resonance Theory -- Architekturen, Implementierung und Anwendung', Master's thesis, IPVR, University of Stuttgart. (in German)

Zell, A. et al. (1998), 'SNNS Stuttgart Neural Network Simulator User Manual, Version 4.2', IPVR, University of Stuttgart and WSI, University of Tübingen. 
\url{https://www.ra.cs.uni-tuebingen.de/SNNS/welcome.html}

Zell, A. (1994), Simulation Neuronaler Netze, Addison-Wesley. (in German)
}
\seealso{
\code{\link{art1}}, \code{\link{art2}}
}
