% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KorAPQuery.R
\name{fetchAll,KorAPQuery-method}
\alias{fetchAll,KorAPQuery-method}
\alias{fetchAll}
\title{Fetch all results of a KorAP query.}
\usage{
\S4method{fetchAll}{KorAPQuery}(kqo, verbose = kqo@korapConnection@verbose, ...)
}
\arguments{
\item{kqo}{object obtained from \code{\link[=corpusQuery]{corpusQuery()}}}

\item{verbose}{print progress information if true}

\item{...}{further arguments passed to \code{\link[=fetchNext]{fetchNext()}}}
}
\value{
The updated \code{kqo} object with all results in \verb{@collectedMatches}
}
\description{
\strong{\code{fetchAll}} fetches all results of a KorAP query.
}
\examples{
\dontrun{
# Fetch all metadata of every query hit for "Ameisenplage" and show a summary
q <- KorAPConnection() |>
  corpusQuery("Ameisenplage") |>
  fetchAll()
q@collectedMatches

# Fetch also all KWICs
q <- KorAPConnection() |> auth() |>
 corpusQuery("Ameisenplage", metadataOnly = FALSE) |>
 fetchAll()
q@collectedMatches

# Retrieve title and text sigle metadata of all texts published on 1958-03-12
q <- KorAPConnection() |>
 corpusQuery("<base/s=t>", # this matches each text once
    vc = "pubDate in 1958-03-12",
    fields = c("textSigle", "title"),
) |>
 fetchAll()
q@collectedMatches
}

}
\seealso{
Other corpus search functions: 
\code{\link{corpusQuery,KorAPConnection-method}},
\code{\link{fetchNext,KorAPQuery-method}}
}
\concept{corpus search functions}
