/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Map;
import java.util.Objects;

public class EstimateSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String TOL = "tol";
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private double tol_ = 1.0E-7;
    public static final double DEF_TOL = 1.0E-7;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, TOL), Double.class);
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
    }

    public EstimateSpec() {
    }

    public void reset() {
        this.span_ = new TsPeriodSelector();
        this.tol_ = 1.0E-7;
    }

    public EstimateSpec(EstimateSpec spec) {
        this.tol_ = spec.tol_;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector value) {
        if (value == null) {
            this.span_.all();
        } else {
            this.span_ = value;
        }
    }

    public double getTol() {
        return this.tol_;
    }

    public void setTol(double value) {
        this.tol_ = value;
    }

    public boolean isDefault() {
        return this.tol_ == 1.0E-7 && this.span_.getType() == PeriodSelectorType.All;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Jdk6.Double.hashCode(this.tol_);
        return hash;
    }

    public EstimateSpec clone() {
        try {
            EstimateSpec spec = (EstimateSpec)super.clone();
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof EstimateSpec && this.equals((EstimateSpec)obj);
    }

    private boolean equals(EstimateSpec other) {
        return other.tol_ == this.tol_ && Objects.equals(other.span_, this.span_);
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (verbose || this.tol_ != 1.0E-7) {
            info.add(TOL, Double.valueOf(this.tol_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Double tol;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((tol = info.get(TOL, Double.class)) != null) {
                this.tol_ = tol;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

