/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.List;

public class TrigonometricVariables
implements ITsVariable {
    private final double[] freq;

    public static TrigonometricVariables regular(int periodicity) {
        int n = periodicity / 2;
        double[] freq = new double[n];
        double f = 2.0 / (double)periodicity;
        for (int i = 1; i <= n; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricVariables(freq);
    }

    public static TrigonometricVariables regular(int periodicity, int[] seasfreq) {
        double[] freq = new double[seasfreq.length];
        double f = 2.0 / (double)periodicity;
        for (int i = 0; i < seasfreq.length; ++i) {
            freq[i] = f * (double)seasfreq[i];
        }
        return new TrigonometricVariables(freq);
    }

    public static TrigonometricVariables all(double periodicity, int nfreq) {
        double[] freq = new double[nfreq];
        double f = 2.0 / periodicity;
        for (int i = 1; i <= nfreq; ++i) {
            freq[i - 1] = f * (double)i;
        }
        return new TrigonometricVariables(freq);
    }

    public TrigonometricVariables(double[] freq) {
        this.freq = freq;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        int start = domain.startId();
        int nlast = this.freq.length - 1;
        if (this.freq[nlast] != 1.0) {
            ++nlast;
        }
        for (int i = 0; i < nlast; ++i) {
            double w = this.freq[i] * Math.PI;
            DataBlock c = data.get(2 * i);
            c.set(k -> Math.cos(w * (double)(k + start)));
            DataBlock s = data.get(2 * i + 1);
            s.set(k -> Math.sin(w * (double)(k + start)));
        }
        if (nlast < this.freq.length) {
            DataBlock c = data.get(2 * nlast);
            c.set(k -> (k + start) % 2 == 0 ? 1.0 : -1.0);
        }
    }

    @Override
    public TsDomain getDefinitionDomain() {
        return null;
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return TsFrequency.Undefined;
    }

    @Override
    public String getDescription(TsFrequency context) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getDim() {
        int n = this.freq.length;
        return this.freq[n - 1] == 1.0 ? 2 * n - 1 : 2 * n;
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getName() {
        return "trig#" + this.getDim();
    }
}

