/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.file;

import demetra.workspace.WorkspaceFamily;
import demetra.workspace.file.Index;
import demetra.workspace.file.Indexer;
import demetra.workspace.file.xml.XmlLegacyWorkspace;
import demetra.workspace.file.xml.XmlLegacyWorkspaceItem;
import demetra.workspace.io.JaxbUtil;
import demetra.workspace.util.Paths;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

final class LegacyIndexer
implements Indexer {
    private final Path file;
    private static final JAXBContext XML_WS_CONTEXT = JaxbUtil.createContext(XmlLegacyWorkspace.class);

    static boolean isValid(Path file) throws IOException {
        try {
            LegacyIndexer.unmarshalIndex(file);
            return true;
        }
        catch (JAXBException ex) {
            return false;
        }
    }

    LegacyIndexer(Path file) {
        this.file = file;
    }

    @Override
    public void checkId(Index.Key key) throws IOException {
        if (WorkspaceFamily.UTIL_CAL.equals((Object)key.getFamily())) {
            if (!key.getId().equals("Calendars")) {
                throw new IOException("Only one calendar file is allowed");
            }
        } else if (WorkspaceFamily.UTIL_VAR.equals((Object)key.getFamily()) && !key.getId().equals("Variables")) {
            throw new IOException("Only one variable file is allowed");
        }
    }

    @Override
    public Index loadIndex() throws IOException {
        try {
            return LegacyIndexer.xmlToIndex(LegacyIndexer.unmarshalIndex(this.file), Paths.changeExtension(this.file.toString(), null));
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void storeIndex(Index index) throws IOException {
        try {
            LegacyIndexer.marshalIndex(this.file, LegacyIndexer.indexToXml(index));
        }
        catch (JAXBException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
    }

    private static Index xmlToIndex(XmlLegacyWorkspace xml, String name) {
        Index.Builder result = Index.builder().name(name);
        JaxbUtil.forSingle(xml.calendars, LegacyIndexer.pusher(result, WorkspaceFamily.UTIL_CAL));
        JaxbUtil.forSingle(xml.variables, LegacyIndexer.pusher(result, WorkspaceFamily.UTIL_VAR));
        JaxbUtil.forEach(xml.saProcessing, LegacyIndexer.pusher(result, WorkspaceFamily.SA_MULTI));
        JaxbUtil.forEach(xml.tramoseatsDocs, LegacyIndexer.pusher(result, WorkspaceFamily.SA_DOC_TRAMOSEATS));
        JaxbUtil.forEach(xml.tramoseatsSpecs, LegacyIndexer.pusher(result, WorkspaceFamily.SA_SPEC_TRAMOSEATS));
        JaxbUtil.forEach(xml.x12Docs, LegacyIndexer.pusher(result, WorkspaceFamily.SA_DOC_X13));
        JaxbUtil.forEach(xml.x12Specs, LegacyIndexer.pusher(result, WorkspaceFamily.SA_SPEC_X13));
        return result.build();
    }

    private static Consumer<XmlLegacyWorkspaceItem> pusher(Index.Builder result, WorkspaceFamily family) {
        return o -> result.item(LegacyIndexer.getIndexKey(o, family), LegacyIndexer.getIndexValue(o));
    }

    private static Index.Key getIndexKey(XmlLegacyWorkspaceItem xml, WorkspaceFamily family) {
        return new Index.Key(family, xml.file != null ? xml.file : xml.name);
    }

    private static Index.Value getIndexValue(XmlLegacyWorkspaceItem xml) {
        return new Index.Value(xml.name, xml.readOnly, null);
    }

    private static XmlLegacyWorkspace indexToXml(Index index) {
        XmlLegacyWorkspace result = new XmlLegacyWorkspace();
        result.calendars = LegacyIndexer.toSingleItem(index, WorkspaceFamily.UTIL_CAL);
        result.variables = LegacyIndexer.toSingleItem(index, WorkspaceFamily.UTIL_VAR);
        result.saProcessing = LegacyIndexer.toEachItem(index, WorkspaceFamily.SA_MULTI);
        result.tramoseatsDocs = LegacyIndexer.toEachItem(index, WorkspaceFamily.SA_DOC_TRAMOSEATS);
        result.tramoseatsSpecs = LegacyIndexer.toEachItem(index, WorkspaceFamily.SA_SPEC_TRAMOSEATS);
        result.x12Docs = LegacyIndexer.toEachItem(index, WorkspaceFamily.SA_DOC_X13);
        result.x12Specs = LegacyIndexer.toEachItem(index, WorkspaceFamily.SA_SPEC_X13);
        return result;
    }

    private static XmlLegacyWorkspaceItem toSingleItem(Index index, WorkspaceFamily family) {
        return index.getItems().entrySet().stream().filter(LegacyIndexer.filterOnFamily(family)).map(LegacyIndexer::map).findFirst().orElse(null);
    }

    private static XmlLegacyWorkspaceItem[] toEachItem(Index index, WorkspaceFamily family) {
        return (XmlLegacyWorkspaceItem[])index.getItems().entrySet().stream().filter(LegacyIndexer.filterOnFamily(family)).map(LegacyIndexer::map).toArray(XmlLegacyWorkspaceItem[]::new);
    }

    private static Predicate<Map.Entry<Index.Key, Index.Value>> filterOnFamily(WorkspaceFamily family) {
        return o -> ((Index.Key)o.getKey()).getFamily().equals((Object)family);
    }

    private static XmlLegacyWorkspaceItem map(Map.Entry<Index.Key, Index.Value> o) {
        XmlLegacyWorkspaceItem result = new XmlLegacyWorkspaceItem();
        result.file = o.getKey().getId();
        result.name = o.getValue().getLabel();
        result.readOnly = o.getValue().isReadOnly();
        return result;
    }

    private static XmlLegacyWorkspace unmarshalIndex(Path file) throws JAXBException, IOException {
        return (XmlLegacyWorkspace)JaxbUtil.unmarshal(file, XML_WS_CONTEXT);
    }

    private static void marshalIndex(Path file, XmlLegacyWorkspace jaxbElement) throws JAXBException, IOException {
        JaxbUtil.marshal(file, XML_WS_CONTEXT, jaxbElement, true);
    }
}

