/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.polynomials.UnitRoots;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractOutlierVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class SeasonalOutlier
extends AbstractOutlierVariable {
    public static final String CODE = "SO";
    boolean zeroEnded;

    public SeasonalOutlier(Day pos) {
        super(pos);
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        TsPeriod pstart = new TsPeriod(start.getFrequency(), this.position);
        int pos = pstart.minus(start);
        data.set(0.0);
        int freq = start.getFrequency().intValue();
        double z = -1.0 / (double)(freq - 1);
        int len = data.getLength();
        if (this.zeroEnded) {
            int xpos;
            int j = 1;
            if (pos < 0) {
                return;
            }
            if (pos > len) {
                int n = pos - len;
                j = 1 + n % freq;
                xpos = len;
            } else {
                xpos = pos;
            }
            while (true) {
                if (j < freq && xpos > 0) {
                    data.set(--xpos, z);
                    ++j;
                    continue;
                }
                if (xpos > 0) {
                    data.set(--xpos, 1.0);
                    j = 1;
                    continue;
                }
                break;
            }
        } else {
            int j;
            int xpos = pos < 0 ? pos % freq : pos;
            if (xpos < 0) {
                int max = Math.min(len, freq + xpos);
                for (j = 0; j < max; ++j) {
                    data.set(j, z);
                }
                xpos += freq;
            }
            int i = xpos;
            while (i < len) {
                data.set(i++, 1.0);
                for (j = 1; j < freq && i < len; ++i, ++j) {
                    data.set(i, z);
                }
            }
        }
    }

    @Override
    public OutlierType getOutlierType() {
        return OutlierType.SO;
    }

    @Override
    public String getCode() {
        return CODE;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        if (domain.getFrequency() == TsFrequency.Yearly) {
            return false;
        }
        return domain.search(this.position) >= 0;
    }

    public boolean isZeroEnded() {
        return this.zeroEnded;
    }

    public void setZeroEnded(boolean value) {
        this.zeroEnded = value;
    }

    @Override
    public IOutlierVariable.FilterRepresentation getFilterRepresentation(int freq) {
        if (freq == 1) {
            return null;
        }
        return new IOutlierVariable.FilterRepresentation(new RationalBackFilter(BackFilter.ONE, new BackFilter(UnitRoots.D(freq))), 0.0);
    }
}

