/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;

public class SsfVarianceAdapter
implements ISsf {
    private final double var_;
    private final ISsf master_;

    public SsfVarianceAdapter(ISsf master, double vmul) {
        this.master_ = master;
        this.var_ = vmul;
    }

    public double getVarianceMultiplier() {
        return this.var_;
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix lm) {
        this.master_.L(pos, k, lm);
    }

    @Override
    public void VpZdZ(int pos, SubMatrix vm, double d) {
        this.master_.VpZdZ(pos, vm, d);
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        this.master_.XpZd(pos, x, d);
    }

    @Override
    public void Z(int pos, DataBlock x) {
        this.master_.Z(pos, x);
    }

    @Override
    public void ZM(int pos, SubMatrix m, DataBlock x) {
        this.master_.ZM(pos, m, x);
    }

    @Override
    public double ZVZ(int pos, SubMatrix vm) {
        return this.master_.ZVZ(pos, vm);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        return this.master_.ZX(pos, x);
    }

    @Override
    public void diffuseConstraints(SubMatrix b) {
        this.master_.diffuseConstraints(b);
    }

    @Override
    public void fullQ(int pos, SubMatrix qm) {
        this.master_.fullQ(pos, qm);
        qm.mul(this.var_);
    }

    @Override
    public int getNonStationaryDim() {
        return this.master_.getNonStationaryDim();
    }

    @Override
    public int getStateDim() {
        return this.master_.getStateDim();
    }

    @Override
    public int getTransitionResCount() {
        return this.master_.getTransitionResCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.master_.getTransitionResDim();
    }

    @Override
    public boolean hasR() {
        return this.master_.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        return this.master_.hasTransitionRes(pos);
    }

    @Override
    public boolean hasW() {
        return this.master_.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.master_.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return this.master_.isMeasurementEquationTimeInvariant();
    }

    @Override
    public boolean isTimeInvariant() {
        return this.master_.isTimeInvariant();
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return this.master_.isTransitionEquationTimeInvariant();
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return this.master_.isTransitionResidualTimeInvariant();
    }

    @Override
    public boolean isValid() {
        return this.var_ >= 0.0 && this.master_.isValid();
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.master_.Pf0(pf0);
        pf0.mul(this.var_);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.master_.Pi0(pi0);
    }

    @Override
    public void Q(int pos, SubMatrix qm) {
        this.master_.Q(pos, qm);
        qm.mul(this.var_);
    }

    @Override
    public void R(int pos, SubArrayOfInt rv) {
        this.master_.R(pos, rv);
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.master_.T(pos, tr);
    }

    @Override
    public void TVT(int pos, SubMatrix vm) {
        this.master_.TVT(pos, vm);
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.master_.TX(pos, x);
    }

    @Override
    public void W(int pos, SubMatrix wv) {
        this.master_.W(pos, wv);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.master_.XT(pos, x);
    }
}

