/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.maths.matrices.LuDecomposition;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public class CroutDoolittle
extends LuDecomposition {
    @Override
    public void decompose(Matrix m) {
        this.init(m, true);
        this.croutdoolittle();
    }

    @Override
    public void decompose(SubMatrix m) {
        this.init(new Matrix(m), false);
        this.croutdoolittle();
    }

    private void croutdoolittle() {
        double[] LUcolj = new double[this.n_];
        for (int j = 0; j < this.n_; ++j) {
            int jj;
            int i = 0;
            int idx = j * this.n_;
            while (i < this.n_) {
                LUcolj[i] = this.lu_[idx];
                ++i;
                ++idx;
            }
            i = 0;
            idx = 0;
            while (i < this.n_) {
                int kmax = i <= j ? i : j;
                double s = 0.0;
                for (int k = 0; k < kmax; ++k) {
                    s += this.lu_[idx + k * this.n_] * LUcolj[k];
                }
                int n = i++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                this.lu_[idx + j * this.n_] = d;
                ++idx;
            }
            int p = j;
            for (int i2 = j + 1; i2 < this.n_; ++i2) {
                if (!(Math.abs(LUcolj[i2]) > Math.abs(LUcolj[p]))) continue;
                p = i2;
            }
            if (p != j) {
                int k = 0;
                int pk = p;
                int jk = j;
                while (k < this.n_) {
                    double t = this.lu_[pk];
                    this.lu_[pk] = this.lu_[jk];
                    this.lu_[jk] = t;
                    ++k;
                    pk += this.n_;
                    jk += this.n_;
                }
                int kk = this.piv_[p];
                this.piv_[p] = this.piv_[j];
                this.piv_[j] = kk;
                this.pivsign_ = -this.pivsign_;
            }
            if (Math.abs(this.lu_[jj = j * this.n_ + j]) < this.getEpsilon()) {
                throw new MatrixException("LU decomposition: Singular matrix");
            }
            for (int i3 = j + 1; i3 < this.n_; ++i3) {
                int n = j * this.n_ + i3;
                this.lu_[n] = this.lu_[n] / this.lu_[jj];
            }
        }
    }
}

