/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.Forecasts;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.ssf.DiffuseFilteringResults;
import ec.tstoolkit.ssf.DiffuseVarianceFilter;
import ec.tstoolkit.ssf.Filter;
import ec.tstoolkit.ssf.FilteredData;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.arima.SsfArima;
import java.util.List;

public class SsfArimaForecasts {
    public <M extends IArimaModel> Forecasts calcForecast(RegArimaEstimation<M> regarima, List<double[]> x, int fHorizon, boolean unbiased, int nhp) {
        int i;
        int nx;
        if (fHorizon <= 0) {
            return null;
        }
        DataBlock y = regarima.model.getY();
        Object arima = regarima.model.getArima();
        int n = nx = x == null ? 0 : x.size();
        if (regarima.model.isMeanCorrection()) {
            ++nx;
        }
        Forecasts fcasts = new Forecasts(fHorizon);
        int n2 = regarima.model.getObsCount();
        SsfArima ssf = new SsfArima((IArimaModel)arima);
        Filter<SsfArima> filter = new Filter<SsfArima>();
        SsfArima.Initializer initializer = new SsfArima.Initializer();
        filter.setSsf(ssf);
        DiffuseFilteringResults frslts = new DiffuseFilteringResults(true);
        frslts.getFilteredData().setSavingA(true);
        double[] yc = new double[n2 + fHorizon];
        y.copyTo(yc, 0);
        for (int i2 = n2; i2 < yc.length; ++i2) {
            yc[i2] = Double.NaN;
        }
        int[] missings = regarima.model.getMissings();
        if (missings != null) {
            for (int i3 = 0; i3 < missings.length; ++i3) {
                yc[missings[i3]] = Double.NaN;
            }
        }
        SsfData ssfy = new SsfData(yc, null);
        filter.process(ssfy, frslts);
        DiffuseVarianceFilter vfilter = frslts.getVarianceFilter();
        FilteredData fdata = frslts.getFilteredData();
        double mvar = regarima.likelihood.getSsqErr() / (double)regarima.likelihood.getDegreesOfFreedom(unbiased, nhp);
        for (i = 0; i < fHorizon; ++i) {
            fcasts.f_[i] = fdata.A(n2 + i).get(0);
            fcasts.ef_[i] = vfilter.F(n2 + i) * mvar;
        }
        if (nx > 0) {
            int pos = ssf.getNonStationaryDim();
            double[] a0 = new double[ssf.getStateDim()];
            int icur = 0;
            int mcur = 0;
            int[] idx = new int[nx];
            if (regarima.model.isMeanCorrection()) {
                idx[icur++] = mcur++;
            }
            mcur += regarima.model.getMissingsCount();
            for (int i4 = 0; i4 < regarima.model.getXCount(); ++i4) {
                idx[icur++] = mcur++;
            }
            double[] c = new double[nx];
            Matrix v = new Matrix(nx, nx);
            double[] b = regarima.likelihood.getB();
            Matrix V = regarima.likelihood.getBVar(unbiased, nhp);
            for (int i5 = 0; i5 < nx; ++i5) {
                c[i5] = b[idx[i5]];
                for (int j = 0; j < nx; ++j) {
                    v.set(i5, j, V.get(idx[i5], idx[j]));
                }
            }
            Matrix xe = new Matrix(fHorizon, nx);
            int ix = 0;
            for (int i6 = 0; i6 < nx; ++i6) {
                double[] xcur = null;
                if (i6 == 0 && regarima.model.isMeanCorrection()) {
                    xcur = regarima.model.calcMeanReg(n2 + fHorizon);
                } else {
                    regarima.model.X(ix).copyTo(yc, 0);
                    xcur = yc;
                }
                SsfData ssfx = new SsfData(xcur, null);
                initializer.calcInitialState(ssf, new DataBlock(a0), ssfx);
                vfilter.process(fdata, pos, xcur, a0);
                for (int j = 0; j < fHorizon; ++j) {
                    xe.set(j, i6, fdata.E(n2 + j));
                }
            }
            DataBlock C = new DataBlock(c);
            DataBlockIterator xrows = xe.rows();
            DataBlock xrow = xrows.getData();
            do {
                int n3 = xrows.getPosition();
                fcasts.f_[n3] = fcasts.f_[n3] + xrow.dot(C);
                int n4 = xrows.getPosition();
                fcasts.ef_[n4] = fcasts.ef_[n4] + SymmetricMatrix.quadraticForm(v, xrow);
            } while (xrows.next());
        }
        for (i = 0; i < fHorizon; ++i) {
            fcasts.ef_[i] = Math.sqrt(fcasts.ef_[i]);
        }
        return fcasts;
    }
}

