/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.design.Internal;
import ec.tstoolkit.design.VisibleForTesting;
import ec.tstoolkit.timeseries.simplets.ObsList;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.ObjLongToIntFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Internal
final class ObsLists {
    private ObsLists() {
    }

    static final class PreSortedLongObsList
    implements ObsList.LongObsList {
        private final ObjLongToIntFunction<TsFrequency> tsPeriodIdFunc;
        private long[] periods;
        private double[] values;
        private int size;

        @VisibleForTesting
        PreSortedLongObsList(ObjLongToIntFunction<TsFrequency> tsPeriodIdFunc, int initialCapacity) {
            this.tsPeriodIdFunc = tsPeriodIdFunc;
            this.periods = new long[initialCapacity];
            this.values = new double[initialCapacity];
            this.size = 0;
        }

        private void grow() {
            int oldCapacity = this.periods.length;
            int newCapacity = Math.min(oldCapacity * 2, Integer.MAX_VALUE);
            this.periods = Arrays.copyOf(this.periods, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public void add(long period, double value) {
            if (this.size + 1 == this.periods.length) {
                this.grow();
            }
            this.periods[this.size] = period;
            this.values[this.size] = value;
            ++this.size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public double getValue(int index) {
            return this.values[index];
        }

        @Override
        public int getPeriodId(TsFrequency frequency, int index) {
            return this.tsPeriodIdFunc.applyAsInt(frequency, this.periods[index]);
        }

        @Override
        public void sortByPeriod() {
        }

        @Override
        public double[] getValues() {
            return Arrays.copyOf(this.values, this.size);
        }
    }

    static final class SortableLongObsList
    implements ObsList.LongObsList {
        private final ObjLongToIntFunction<TsFrequency> tsPeriodIdFunc;
        private final List<LongObs> list = new ArrayList<LongObs>();
        private boolean sorted = true;
        private long latestPeriod = Long.MIN_VALUE;

        @VisibleForTesting
        SortableLongObsList(ObjLongToIntFunction<TsFrequency> tsPeriodIdFunc) {
            this.tsPeriodIdFunc = tsPeriodIdFunc;
        }

        @VisibleForTesting
        boolean isSorted() {
            return this.sorted;
        }

        @Override
        public void clear() {
            this.list.clear();
            this.sorted = true;
            this.latestPeriod = Long.MIN_VALUE;
        }

        @Override
        public void add(long period, double value) {
            this.list.add(new LongObs(period, value));
            this.sorted = this.sorted && this.latestPeriod <= period;
            this.latestPeriod = period;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public double getValue(int index) {
            return this.list.get((int)index).value;
        }

        @Override
        public int getPeriodId(TsFrequency frequency, int index) {
            return this.tsPeriodIdFunc.applyAsInt(frequency, this.list.get((int)index).period);
        }

        @Override
        public void sortByPeriod() {
            if (!this.sorted) {
                this.list.sort((l, r) -> Long.compare(l.period, r.period));
                this.sorted = true;
                this.latestPeriod = this.list.get((int)(this.list.size() - 1)).period;
            }
        }

        private static final class LongObs {
            final long period;
            final double value;

            private LongObs(long period, double value) {
                this.period = period;
                this.value = value;
            }
        }
    }
}

