/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.WindowType;
import java.util.function.IntToDoubleFunction;

public class WindowFunction {
    private final double[] window;

    public WindowFunction(WindowType type, int len) {
        this.window = type.window(len);
    }

    public double computeSymmetric(IntToDoubleFunction fn) {
        double v = fn.applyAsDouble(0) * this.window[0];
        for (int i = 1; i < this.window.length; ++i) {
            v += 2.0 * this.window[i] * fn.applyAsDouble(i);
        }
        return v;
    }

    public double compute(IntToDoubleFunction fn) {
        double v = fn.applyAsDouble(0) * this.window[0];
        for (int i = 1; i < this.window.length; ++i) {
            v += this.window[i] * fn.applyAsDouble(i);
            v += this.window[i] * fn.applyAsDouble(-i);
        }
        return v;
    }
}

