% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_adapters.R
\name{yahoo_adapter}
\alias{yahoo_adapter}
\title{Download Price Data from Yahoo Finance}
\usage{
yahoo_adapter(symbols, start_date, end_date, frequency = "daily")
}
\arguments{
\item{symbols}{Character vector of stock symbols}

\item{start_date}{Start date in "YYYY-MM-DD" format}

\item{end_date}{End date in "YYYY-MM-DD" format}

\item{frequency}{"daily" or "weekly" (default: "daily")}
}
\value{
Data.table with Date column and one column per symbol
}
\description{
Downloads stock price data directly from Yahoo Finance using quantmod.
No database required - perfect for quick analysis and experimentation.
Get started with real data in under 5 minutes.
}
\examples{
# Use included sample data
data(sample_prices_weekly)

# Build a quick momentum strategy with offline data
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 2)
weights <- weight_equally(selected)
result <- run_backtest(sample_prices_weekly, weights, initial_capital = 100000)

\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download tech stocks (requires internet, skipped on CRAN)
if (requireNamespace("quantmod", quietly = TRUE)) {
  prices <- yahoo_adapter(
    symbols = c("AAPL", "MSFT", "GOOGL"),
    start_date = "2023-01-01",
    end_date = "2023-12-31",
    frequency = "weekly"
  )
  momentum <- calc_momentum(prices, lookback = 12)
}
\dontshow{\}) # examplesIf}
}
