% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment.functions.R
\name{portfolio.moments.bl}
\alias{portfolio.moments.bl}
\title{Portfolio Moments}
\usage{
portfolio.moments.bl(
  R,
  portfolio,
  momentargs = NULL,
  P,
  Mu = NULL,
  Sigma = NULL,
  ...
)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of 
asset returns}

\item{portfolio}{an object of type \code{portfolio} specifying the 
constraints and objectives for the optimization, see 
\code{\link{portfolio.spec}}}

\item{momentargs}{list containing arguments to be passed down to lower level 
functions, default NULL}

\item{P}{a K x N pick matrix representing views}

\item{Mu}{vector of length N of the prior expected values. The sample mean
is used if \code{Mu=NULL}.}

\item{Sigma}{an N x N matrix of the prior covariance matrix. The sample 
covariance is used if \code{Sigma=NULL}.}

\item{\dots}{any other passthru parameters}
}
\description{
Set portfolio moments for use by lower level optimization functions using
a basic Black Litterman model.
}
\note{
If any of the objectives in the \code{portfolio} object have 
\code{clean} as an argument, the cleaned returns are used to fit the model.
}
