% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{summitMapping,PathwaySpace-method}
\alias{summitMapping,PathwaySpace-method}
\alias{summitMapping}
\title{Mapping Summits on PathwaySpace Images}
\usage{
\S4method{summitMapping}{PathwaySpace}(
  ps,
  maxset = 30,
  minsize = 30,
  threshold = 0.5,
  verbose = TRUE,
  segm_fun = summitWatershed,
  ...
)
}
\arguments{
\item{ps}{A \linkS4class{PathwaySpace} class object.}

\item{maxset}{A single positive integer indicating the maximum number 
of summits to be returned by the segmentation function.}

\item{minsize}{A single positive integer indicating the minimum size 
of the summits.}

\item{threshold}{A threshold provided as a fraction (in \code{[0,1]}) of the
max signal intensity.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}

\item{segm_fun}{A segmentation function used to detect summits
(see \code{\link{summitWatershed}}).}

\item{...}{Additional arguments passed to the segmentation function.}
}
\value{
A preprocessed \linkS4class{PathwaySpace} class object.
}
\description{
The \code{summitMapping} method implements a segmentation
strategy to identify summits on a 2D-landscape image 
(see \code{\link{summitWatershed}}).
}
\examples{
# Load a large igraph
data("PCv12_pruned_igraph", package = "PathwaySpace")

# Continue this example from the PathwaySpace vignette,
# in the 'PathwaySpace decoration' section

}
\seealso{
\code{\link{circularProjection}}
}
\author{
Mauro Castro and TCGA Network.
}
