% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airsis_availableUnits.R
\name{airsis_availableUnits}
\alias{airsis_availableUnits}
\title{Get AIRSIS available unit identifiers}
\usage{
airsis_availableUnits(startdate = strftime(lubridate::now("UTC"),
  "\%Y010100", tz = "UTC"), enddate = strftime(lubridate::now("UTC"),
  "\%Y\%m\%d23", tz = "UTC"), provider = "USFS",
  unitTypes = c("BAM1020", "EBAM", "ESAM"),
  baseUrl = "http://xxxx.airsis.com/vision/common/CSVExport.aspx?")
}
\arguments{
\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{enddate}{desired end date (integer or character representing YYYYMMDD[HH])}

\item{provider}{identifier used to modify baseURL \code{['APCD'|'USFS']}}

\item{unitTypes}{vector of unit types}

\item{baseUrl}{base URL for data queries}
}
\value{
Vector of AIRSIS unitIDs.
}
\description{
Returns a list of unitIDs with data during a particular time period.
}
\examples{
\dontrun{
unitIDs <- airsis_availableUnits(20150701, 20151231,
                                 provider = 'USFS',
                                 unitTypes = c('EBAM','ESAM'))
}
}
\references{
\href{http://usfs.airsis.com}{Interagency Real Time Smoke Monitoring}
}
\keyword{AIRSIS}
