#' Plot running score plot for the results of psea
#'
#' @description This function takes results generated by \code{\link{runPSEA}}. It plots running enrichment score of
#' ranked protein for each PTM.
#'
#' @param x A list of 6 generated by runPSEA function.
#' @param nplot An integer that defines the number of running score plots to show. Default value is the number of enriched PTMs in x.
#' @param type Type of line used in the plot.
#' @param lty A list of 6 generated by runPSEA function.
#' @param lwd line width
#' @param cex Specify the size of the title text
#' @param cex.axis Specify the size of the tick label
#' @param cex.lab Specify the size of the axis label text
#' @param col Color of running enrichment score line
#'
#' @return Plot
#'
#' @export
#'
#' @importFrom graphics abline rug par
#'
#' @examples
#' # We recommend at least nperm = 1000.
#' # The number of permutations was reduced to 10
#' # to accommodate CRAN policy on examples (run time <= 5 seconds).
#' psea_res <- runPSEA(protein = exmplData2, os.name = 'Rattus norvegicus (Rat)', nperm = 10)
#' plotRunningScore(x = psea_res)
plotRunningScore = function(x, nplot = length(x$psea.result), type = 'l', lty = 1, lwd = 3, cex = 1.2, cex.axis = 1.2, cex.lab = 1.1, col = 'blue'){


  # Make sure the package does not change default valus of par() function for user.
  oldpar <- par(no.readonly = TRUE)
  on.exit(par(oldpar))
  ################################################################################

  y <- x$psea.result
  par(mfrow = c(2,2))

  for( i in 1:nplot ){
      plot(x = 1:length(y[[i]]$phit),
           y = y[[i]]$phit - y[[i]]$pmiss,
           type = type,
           lty = lty,
           lwd = lwd,
           cex = cex,
           cex.axis = cex.axis,
           cex.lab = cex.lab,
           col = col,
           main = as.character( x$res[i,'PTM'] ),
           ylab = 'Running Enrichment Score',
           xlab = 'Ranked Protein List')
      rug(   x = unlist(x$rug.indx[i]),   lwd = 3, side = 1, ticksize = 0.1, col = 'black')
      abline(v = unlist(x$x.max.indx[i]), col = 'red', lty = 3, lwd = 3)
      abline(h = unlist(x$y.max.indx[i]), col = 'red', lty = 3, lwd = 3)
    }


}
