% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TNdfF.R
\name{TNdfF}
\alias{TNdfF}
\title{Calculate Total N derived from Fertilizer (TNdfF)}
\usage{
TNdfF(NdfF, PlantN = NULL, SoilN = NULL)
}
\arguments{
\item{NdfF}{N derived from Fertilizer expressed as a percentage.}

\item{PlantN}{A numeric vector of values for plant N content.}

\item{SoilN}{A numeric value for soil N content.}
}
\value{
The calculated TNdfF value.
}
\description{
The total quantity of plant or soil N that is derived from fertilizer
Calculate TNdfF using the formula: TNdfF = (NdfF/100) * Plant N or Soil N
}
\examples{
NdfF <- 25.98333
SoilN <- 20
PlantN <- c(12.1, 8.99, 12.89, 13.11)
TNdfF(NdfF, PlantN)
TNdfF(NdfF, SoilN)
}
\references{
Primary: Congreves, K. A., Otchere, O., Ferland, D., Farzadfar, S., Williams, S., & Arcand, M. M. (2021, June 4).
Nitrogen Use Efficiency Definitions of Today and Tomorrow. Frontiers in Plant Science, 12.
https://doi.org/10.3389/fpls.2021.637108

Secondary: IAEA (1983). Guide on the Use of Nitrogen-15 and Radioisotopes in Studies of Plant Nutrition:
Calculations and Interpretation of Data. Vienna: IAEA.
}
