/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.slopeone;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.common.Weighting;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.impl.recommender.slopeone.MemoryDiffStorage;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.slopeone.DiffStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlopeOneRecommender
extends AbstractRecommender {
    private static final Logger log = LoggerFactory.getLogger(SlopeOneRecommender.class);
    private final boolean weighted;
    private final boolean stdDevWeighted;
    private final DiffStorage diffStorage;

    public SlopeOneRecommender(DataModel dataModel) throws TasteException {
        this(dataModel, Weighting.WEIGHTED, Weighting.WEIGHTED, new MemoryDiffStorage(dataModel, Weighting.WEIGHTED, Long.MAX_VALUE));
    }

    public SlopeOneRecommender(DataModel dataModel, Weighting weighting, Weighting stdDevWeighting, DiffStorage diffStorage) {
        super(dataModel);
        Preconditions.checkArgument(stdDevWeighting != Weighting.WEIGHTED || weighting != Weighting.UNWEIGHTED, "weighted required when stdDevWeighted is set");
        Preconditions.checkArgument(diffStorage != null, "diffStorage is null");
        this.weighted = weighting == Weighting.WEIGHTED;
        this.stdDevWeighted = stdDevWeighting == Weighting.WEIGHTED;
        this.diffStorage = diffStorage;
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument(howMany >= 1, "howMany must be at least 1");
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        FastIDSet possibleItemIDs = this.diffStorage.getRecommendableItemIDs(userID);
        Estimator estimator = new Estimator(userID);
        List<RecommendedItem> topItems = TopItems.getTopItems(howMany, possibleItemIDs.iterator(), rescorer, estimator);
        log.debug("Recommendations are: {}", (Object)topItems);
        return topItems;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        DataModel model = this.getDataModel();
        Float actualPref = model.getPreferenceValue(userID, itemID);
        if (actualPref != null) {
            return actualPref.floatValue();
        }
        return this.doEstimatePreference(userID, itemID);
    }

    private float doEstimatePreference(long userID, long itemID) throws TasteException {
        double count = 0.0;
        double totalPreference = 0.0;
        PreferenceArray prefs = this.getDataModel().getPreferencesFromUser(userID);
        RunningAverage[] averages = this.diffStorage.getDiffs(userID, itemID, prefs);
        int size = prefs.length();
        for (int i = 0; i < size; ++i) {
            RunningAverage averageDiff = averages[i];
            if (averageDiff == null) continue;
            double averageDiffValue = averageDiff.getAverage();
            if (this.weighted) {
                double stdev;
                double weight = averageDiff.getCount();
                if (this.stdDevWeighted && !Double.isNaN(stdev = ((RunningAverageAndStdDev)averageDiff).getStandardDeviation())) {
                    weight /= 1.0 + stdev;
                }
                totalPreference += weight * ((double)prefs.getValue(i) + averageDiffValue);
                count += weight;
                continue;
            }
            totalPreference += (double)prefs.getValue(i) + averageDiffValue;
            count += 1.0;
        }
        if (count <= 0.0) {
            RunningAverage itemAverage = this.diffStorage.getAverageItemPref(itemID);
            return itemAverage == null ? Float.NaN : (float)itemAverage.getAverage();
        }
        return (float)(totalPreference / count);
    }

    @Override
    public void setPreference(long userID, long itemID, float value) throws TasteException {
        Float oldPref;
        DataModel dataModel = this.getDataModel();
        try {
            oldPref = dataModel.getPreferenceValue(userID, itemID);
        }
        catch (NoSuchUserException nsee) {
            oldPref = null;
        }
        super.setPreference(userID, itemID, value);
        if (oldPref == null) {
            this.diffStorage.addItemPref(userID, itemID, value);
        } else {
            this.diffStorage.updateItemPref(itemID, value - oldPref.floatValue());
        }
    }

    @Override
    public void removePreference(long userID, long itemID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        Float oldPref = dataModel.getPreferenceValue(userID, itemID);
        super.removePreference(userID, itemID);
        if (oldPref != null) {
            this.diffStorage.removeItemPref(userID, itemID, oldPref.floatValue());
        }
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.diffStorage);
    }

    public String toString() {
        return "SlopeOneRecommender[weighted:" + this.weighted + ", stdDevWeighted:" + this.stdDevWeighted + ", diffStorage:" + this.diffStorage + ']';
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private final long userID;

        private Estimator(long userID) {
            this.userID = userID;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            return SlopeOneRecommender.this.doEstimatePreference(this.userID, itemID);
        }
    }
}

