/*
 * Decompiled with CFR 0.152.
 */
package com.lexicalscope.jewel.cli.validation;

import com.lexicalscope.jewel.cli.HelpRequestedException;
import com.lexicalscope.jewel.cli.ValidationErrorBuilder;
import com.lexicalscope.jewel.cli.specification.OptionsSpecification;
import com.lexicalscope.jewel.cli.specification.ParsedOptionSpecification;
import com.lexicalscope.jewel.cli.specification.UnparsedOptionSpecification;
import com.lexicalscope.jewel.cli.validation.ArgumentValidator;
import com.lexicalscope.jewel.cli.validation.OptionCollection;
import com.lexicalscope.jewel.cli.validation.OptionCollectionImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ArgumentValidatorImpl<O>
implements ArgumentValidator {
    private final ValidationErrorBuilder validationErrorBuilder;
    private final Map<ParsedOptionSpecification, List<String>> validatedArguments = new LinkedHashMap<ParsedOptionSpecification, List<String>>();
    private final List<String> validatedUnparsedArguments = new ArrayList<String>();
    private final OptionsSpecification<O> specification;

    public ArgumentValidatorImpl(OptionsSpecification<O> specification, ValidationErrorBuilder validationErrorBuilder) {
        this.specification = specification;
        this.validationErrorBuilder = validationErrorBuilder;
    }

    @Override
    public void processOption(String optionName, List<String> values) {
        if (!this.specification.isSpecified(optionName)) {
            this.validationErrorBuilder.unexpectedOption(optionName);
            return;
        }
        this.processOption(this.specification.getSpecification(optionName), values);
    }

    private void processOption(ParsedOptionSpecification option, List<String> values) {
        if (option.isHelpOption()) {
            throw new HelpRequestedException(this.specification);
        }
        if (!option.allowedThisManyValues(values.size())) {
            this.validationErrorBuilder.wrongNumberOfValues(option, values);
            return;
        }
        this.checkAndAddValues(option, new ArrayList<String>(values));
    }

    @Override
    public void processLastOption(String optionName, List<String> values) {
        if (!this.specification.isSpecified(optionName)) {
            this.validationErrorBuilder.unexpectedOption(optionName);
            return;
        }
        ParsedOptionSpecification optionSpecification = this.specification.getSpecification(optionName);
        this.processOption(optionSpecification, this.trimExcessOptions(values, optionSpecification));
    }

    private List<String> trimExcessOptions(List<String> values, ParsedOptionSpecification optionSpecification) {
        if (!this.specification.hasUnparsedSpecification()) {
            return values;
        }
        int maximumArgumentConsumption = Math.min(values.size(), optionSpecification.maximumArgumentConsumption());
        this.validatedUnparsedArguments.addAll(0, values.subList(maximumArgumentConsumption, values.size()));
        return new ArrayList<String>(values.subList(0, maximumArgumentConsumption));
    }

    @Override
    public void processUnparsed(List<String> values) {
        this.validatedUnparsedArguments.addAll(values);
        this.validateUnparsedOptions();
    }

    @Override
    public OptionCollection finishedProcessing() {
        this.validationErrorBuilder.validate();
        for (ParsedOptionSpecification mandatoryOptionSpecification : this.specification.getMandatoryOptions()) {
            if (this.validatedArguments.containsKey(mandatoryOptionSpecification)) continue;
            this.validationErrorBuilder.missingOption(mandatoryOptionSpecification);
        }
        this.validationErrorBuilder.validate();
        return new OptionCollectionImpl(this.specification, this.validatedArguments, this.validatedUnparsedArguments);
    }

    private void validateUnparsedOptions() {
        if (this.specification.hasUnparsedSpecification()) {
            UnparsedOptionSpecification argumentSpecification = this.specification.getUnparsedSpecification();
            if (!(argumentSpecification.isOptional() && this.validatedUnparsedArguments.isEmpty() || argumentSpecification.allowedThisManyValues(this.validatedUnparsedArguments.size()))) {
                this.validationErrorBuilder.wrongNumberOfValues(argumentSpecification, this.validatedUnparsedArguments);
            }
        } else if (!this.validatedUnparsedArguments.isEmpty()) {
            this.validationErrorBuilder.unexpectedTrailingValue(this.validatedUnparsedArguments);
        }
    }

    private void checkAndAddValues(ParsedOptionSpecification optionSpecification, ArrayList<String> values) {
        for (String value : values) {
            if (optionSpecification.allowedValue(value)) continue;
            this.validationErrorBuilder.patternMismatch(optionSpecification, value);
            return;
        }
        this.validatedArguments.put(optionSpecification, new ArrayList<String>(values));
    }
}

