/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.math.Varint;

public final class EntityEntityWritable
implements WritableComparable<EntityEntityWritable>,
Cloneable {
    private long aID;
    private long bID;

    public EntityEntityWritable() {
    }

    public EntityEntityWritable(long aID, long bID) {
        this.aID = aID;
        this.bID = bID;
    }

    public long getAID() {
        return this.aID;
    }

    public long getBID() {
        return this.bID;
    }

    public void set(long aID, long bID) {
        this.aID = aID;
        this.bID = bID;
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeSignedVarLong(this.aID, out);
        Varint.writeSignedVarLong(this.bID, out);
    }

    public void readFields(DataInput in) throws IOException {
        this.aID = Varint.readSignedVarLong(in);
        this.bID = Varint.readSignedVarLong(in);
    }

    public int compareTo(EntityEntityWritable that) {
        int aCompare = EntityEntityWritable.compare(this.aID, that.getAID());
        return aCompare == 0 ? EntityEntityWritable.compare(this.bID, that.getBID()) : aCompare;
    }

    private static int compare(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public int hashCode() {
        return Longs.hashCode(this.aID) + 31 * Longs.hashCode(this.bID);
    }

    public boolean equals(Object o) {
        if (o instanceof EntityEntityWritable) {
            EntityEntityWritable that = (EntityEntityWritable)o;
            return this.aID == that.getAID() && this.bID == that.getBID();
        }
        return false;
    }

    public String toString() {
        return this.aID + "\t" + this.bID;
    }

    public EntityEntityWritable clone() {
        return new EntityEntityWritable(this.aID, this.bID);
    }
}

