/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class BecauseServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long itemID;
        long userID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            userID = Long.parseLong(pathComponents.next());
            itemID = Long.parseLong(pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            List<RecommendedItem> similar = recommender.recommendedBecause(userID, itemID, BecauseServlet.getHowMany(request));
            this.output(request, response, similar);
        }
        catch (NoSuchUserException nsue) {
            response.sendError(404, nsue.toString());
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
        }
        catch (UnsupportedOperationException uoe) {
            response.sendError(400, uoe.toString());
        }
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long userID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            userID = Long.parseLong(pathComponents.next());
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return userID;
    }
}

