/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.collection;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.myrrix.common.random.RandomUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class FastByIDFloatMap
implements Serializable,
Cloneable {
    private static final float DEFAULT_LOAD_FACTOR = 1.5f;
    private static final long REMOVED = Long.MAX_VALUE;
    private static final long KEY_NULL = Long.MIN_VALUE;
    private static final float VALUE_NULL = Float.NaN;
    long[] keys;
    float[] values;
    private final float loadFactor;
    private int numEntries;
    private int numSlotsUsed;

    public FastByIDFloatMap() {
        this(2);
    }

    public FastByIDFloatMap(int size) {
        this(size, 1.5f);
    }

    public FastByIDFloatMap(int size, float loadFactor) {
        Preconditions.checkArgument(size >= 0, "size must be at least 0");
        Preconditions.checkArgument(loadFactor >= 1.0f, "loadFactor must be at least 1.0");
        this.loadFactor = loadFactor;
        int max = (int)(2.147483E9f / loadFactor);
        Preconditions.checkArgument(size < max, "size must be less than " + max);
        int hashSize = RandomUtils.nextTwinPrime((int)(loadFactor * (float)size));
        this.keys = new long[hashSize];
        Arrays.fill(this.keys, Long.MIN_VALUE);
        this.values = new float[hashSize];
        Arrays.fill(this.values, Float.NaN);
    }

    private int find(long key) {
        int theHashCode = (int)key & Integer.MAX_VALUE;
        long[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        long currentKey = keys[index];
        while (currentKey != Long.MIN_VALUE && key != currentKey) {
            currentKey = keys[index -= index < jump ? jump - hashSize : jump];
        }
        return index;
    }

    private int findForAdd(long key) {
        int theHashCode = (int)key & Integer.MAX_VALUE;
        long[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        long currentKey = keys[index];
        while (currentKey != Long.MIN_VALUE && currentKey != Long.MAX_VALUE && key != currentKey) {
            currentKey = keys[index -= index < jump ? jump - hashSize : jump];
        }
        if (currentKey != Long.MAX_VALUE) {
            return index;
        }
        int addIndex = index;
        while (currentKey != Long.MIN_VALUE && key != currentKey) {
            currentKey = keys[index -= index < jump ? jump - hashSize : jump];
        }
        return key == currentKey ? index : addIndex;
    }

    public float get(long key) {
        if (key == Long.MIN_VALUE) {
            return Float.NaN;
        }
        int index = this.find(key);
        return this.values[index];
    }

    public void increment(long key, float delta) {
        Preconditions.checkArgument(key != Long.MIN_VALUE && key != Long.MAX_VALUE);
        int index = this.find(key);
        float currentValue = this.values[index];
        if (Float.isNaN(currentValue)) {
            this.put(key, delta);
        } else {
            this.values[index] = currentValue + delta;
        }
    }

    public int size() {
        return this.numEntries;
    }

    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    public boolean containsKey(long key) {
        return key != Long.MIN_VALUE && key != Long.MAX_VALUE && this.keys[this.find(key)] != Long.MIN_VALUE;
    }

    public void put(long key, float value) {
        int index;
        long keyIndex;
        Preconditions.checkArgument(key != Long.MIN_VALUE && key != Long.MAX_VALUE);
        if ((float)this.numSlotsUsed * this.loadFactor >= (float)this.keys.length) {
            if ((float)this.numEntries * this.loadFactor >= (float)this.numSlotsUsed) {
                this.growAndRehash();
            } else {
                this.rehash();
            }
        }
        if ((keyIndex = this.keys[index = this.findForAdd(key)]) == key) {
            this.values[index] = value;
        } else {
            this.keys[index] = key;
            this.values[index] = value;
            ++this.numEntries;
            if (keyIndex == Long.MIN_VALUE) {
                ++this.numSlotsUsed;
            }
        }
    }

    public void remove(long key) {
        if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) {
            return;
        }
        int index = this.find(key);
        if (this.keys[index] != Long.MIN_VALUE) {
            this.keys[index] = Long.MAX_VALUE;
            --this.numEntries;
            this.values[index] = Float.NaN;
        }
    }

    public void clear() {
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        Arrays.fill(this.keys, Long.MIN_VALUE);
        Arrays.fill(this.values, Float.NaN);
    }

    public LongPrimitiveIterator keySetIterator() {
        return new KeyIterator();
    }

    public Set<MapEntry> entrySet() {
        return new EntrySet();
    }

    public void rehash() {
        this.rehash(RandomUtils.nextTwinPrime((int)(this.loadFactor * (float)this.numEntries)));
    }

    private void growAndRehash() {
        Preconditions.checkState((float)this.keys.length * this.loadFactor < 2.147483E9f, "Can't grow any more");
        this.rehash(RandomUtils.nextTwinPrime((int)(this.loadFactor * (float)this.keys.length)));
    }

    private void rehash(int newHashSize) {
        long[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        this.keys = new long[newHashSize];
        Arrays.fill(this.keys, Long.MIN_VALUE);
        this.values = new float[newHashSize];
        Arrays.fill(this.values, Float.NaN);
        int length = oldKeys.length;
        for (int i = 0; i < length; ++i) {
            long key = oldKeys[i];
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            this.put(key, oldValues[i]);
        }
    }

    void iteratorRemove(int lastNext) {
        if (lastNext >= this.values.length) {
            throw new NoSuchElementException();
        }
        Preconditions.checkState(lastNext >= 0);
        this.values[lastNext] = Float.NaN;
        this.keys[lastNext] = Long.MAX_VALUE;
        --this.numEntries;
    }

    public FastByIDFloatMap clone() {
        FastByIDFloatMap clone;
        try {
            clone = (FastByIDFloatMap)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
        clone.keys = (long[])this.keys.clone();
        clone.values = (float[])this.values.clone();
        return clone;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder();
        result.append('{');
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            result.append(key).append('=').append(this.values[i]).append(',');
        }
        result.setCharAt(result.length() - 1, '}');
        return result.toString();
    }

    public int hashCode() {
        int hash = 0;
        long[] keys = this.keys;
        int max = keys.length;
        for (int i = 0; i < max; ++i) {
            long key = keys[i];
            if (key == Long.MIN_VALUE || key == Long.MAX_VALUE) continue;
            hash = 31 * hash + ((int)(key >> 32) ^ (int)key);
            hash = 31 * hash + Doubles.hashCode(this.values[i]);
        }
        return hash;
    }

    public boolean equals(Object other) {
        long key;
        int i;
        if (!(other instanceof FastByIDFloatMap)) {
            return false;
        }
        FastByIDFloatMap otherMap = (FastByIDFloatMap)other;
        long[] otherKeys = otherMap.keys;
        float[] otherValues = otherMap.values;
        int length = this.keys.length;
        int otherLength = otherKeys.length;
        int max = FastMath.min(length, otherLength);
        for (i = 0; i < max; ++i) {
            key = this.keys[i];
            long otherKey = otherKeys[i];
            if (!(key == Long.MIN_VALUE || key == Long.MAX_VALUE ? otherKey != Long.MIN_VALUE && otherKey != Long.MAX_VALUE : key != otherKey || this.values[i] != otherValues[i])) continue;
            return false;
        }
        while (i < length) {
            key = this.keys[i];
            if (key != Long.MIN_VALUE && key != Long.MAX_VALUE) {
                return false;
            }
            ++i;
        }
        while (i < otherLength) {
            key = otherKeys[i];
            if (key != Long.MIN_VALUE && key != Long.MAX_VALUE) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final class EntryIterator
    implements Iterator<MapEntry> {
        private int position;
        private int lastNext = -1;
        private final MapEntryImpl entry = new MapEntryImpl();

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goToNext();
            return this.position < FastByIDFloatMap.this.keys.length;
        }

        @Override
        public MapEntry next() {
            this.goToNext();
            this.lastNext = this.position;
            if (this.position >= FastByIDFloatMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            this.entry.setIndex(this.position++);
            return this.entry;
        }

        private void goToNext() {
            int length = FastByIDFloatMap.this.values.length;
            while (this.position < length && Float.isNaN(FastByIDFloatMap.this.values[this.position])) {
                ++this.position;
            }
        }

        @Override
        public void remove() {
            FastByIDFloatMap.this.iteratorRemove(this.lastNext);
        }
    }

    private final class EntrySet
    extends AbstractSet<MapEntry> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return FastByIDFloatMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return FastByIDFloatMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return FastByIDFloatMap.this.containsKey((Long)o);
        }

        @Override
        public Iterator<MapEntry> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean add(MapEntry t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends MapEntry> ts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> objects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            FastByIDFloatMap.this.clear();
        }
    }

    private final class MapEntryImpl
    implements MapEntry {
        private int index;

        private MapEntryImpl() {
        }

        void setIndex(int index) {
            this.index = index;
        }

        @Override
        public long getKey() {
            return FastByIDFloatMap.this.keys[this.index];
        }

        @Override
        public float getValue() {
            return FastByIDFloatMap.this.values[this.index];
        }

        @Override
        public float setValue(float value) {
            float oldValue = FastByIDFloatMap.this.values[this.index];
            FastByIDFloatMap.this.values[this.index] = value;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    public static interface MapEntry {
        public long getKey();

        public float getValue();

        public float setValue(float var1);
    }

    private final class KeyIterator
    extends AbstractLongPrimitiveIterator {
        private int position;
        private int lastNext = -1;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goToNext();
            return this.position < FastByIDFloatMap.this.keys.length;
        }

        @Override
        public long nextLong() {
            this.goToNext();
            this.lastNext = this.position;
            if (this.position >= FastByIDFloatMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return FastByIDFloatMap.this.keys[this.position++];
        }

        @Override
        public long peek() {
            this.goToNext();
            if (this.position >= FastByIDFloatMap.this.keys.length) {
                throw new NoSuchElementException();
            }
            return FastByIDFloatMap.this.keys[this.position];
        }

        private void goToNext() {
            int length = FastByIDFloatMap.this.values.length;
            while (this.position < length && Float.isNaN(FastByIDFloatMap.this.values[this.position])) {
                ++this.position;
            }
        }

        @Override
        public void remove() {
            FastByIDFloatMap.this.iteratorRemove(this.lastNext);
        }

        @Override
        public void skip(int n) {
            this.position += n;
        }
    }
}

