/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;

public final class SequenceFileValueIterable<V extends Writable>
implements Iterable<V> {
    private final Path path;
    private final boolean reuseKeyValueInstances;
    private final Configuration conf;

    public SequenceFileValueIterable(Path path, Configuration conf) {
        this(path, false, conf);
    }

    public SequenceFileValueIterable(Path path, boolean reuseKeyValueInstances, Configuration conf) {
        this.path = path;
        this.reuseKeyValueInstances = reuseKeyValueInstances;
        this.conf = conf;
    }

    @Override
    public Iterator<V> iterator() {
        try {
            return new SequenceFileValueIterator(this.path, this.reuseKeyValueInstances, this.conf);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(this.path.toString(), ioe);
        }
    }
}

