/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.eval;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.myrrix.online.eval.MyrrixIRStatistics;
import net.myrrix.online.eval.ParameterRange;
import net.myrrix.online.eval.PrecisionRecallEvaluator;
import org.apache.commons.math3.util.Pair;
import org.apache.mahout.cf.taste.common.TasteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParameterOptimizer
implements Callable<Map<String, Number>> {
    private static final Logger log = LoggerFactory.getLogger(ParameterOptimizer.class);
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern COLON = Pattern.compile(":");
    private final Map<String, ParameterRange> parameterRanges;
    private final int numSteps;
    private final Callable<? extends Number> evaluator;
    private final boolean minimize;

    public ParameterOptimizer(Map<String, ParameterRange> parameterRanges, Callable<? extends Number> evaluator) {
        this(parameterRanges, 4, evaluator, false);
    }

    public ParameterOptimizer(Map<String, ParameterRange> parameterRanges, int numSteps, Callable<? extends Number> evaluator, boolean minimize) {
        Preconditions.checkNotNull(parameterRanges);
        Preconditions.checkArgument(!parameterRanges.isEmpty(), "parameterRanges is empty");
        Preconditions.checkArgument(numSteps >= 2);
        Preconditions.checkNotNull(evaluator);
        this.parameterRanges = parameterRanges;
        this.numSteps = numSteps;
        this.evaluator = evaluator;
        this.minimize = minimize;
    }

    @Override
    public Map<String, Number> call() throws ExecutionException {
        return this.findGoodParameterValues();
    }

    public Map<String, Number> findGoodParameterValues() throws ExecutionException {
        int numProperties = this.parameterRanges.size();
        String[] propertyNames = new String[numProperties];
        Number[][] parameterValuesToTry = new Number[numProperties][];
        int index = 0;
        for (Map.Entry<String, ParameterRange> entry : this.parameterRanges.entrySet()) {
            propertyNames[index] = entry.getKey();
            parameterValuesToTry[index] = entry.getValue().buildSteps(this.numSteps);
            ++index;
        }
        int numTests = 1;
        for (Number[] toTry : parameterValuesToTry) {
            numTests *= toTry.length;
        }
        ArrayList<Pair<Double, String>> testResultLinesByValue = Lists.newArrayListWithCapacity(numTests);
        HashMap<String, Number> bestParameterValues = Maps.newHashMap();
        double bestValue = this.minimize ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        for (int test = 0; test < numTests; ++test) {
            double testValue;
            StringBuilder testResultLine = new StringBuilder();
            for (int prop = 0; prop < numProperties; ++prop) {
                String property = propertyNames[prop];
                Number parameterValue = ParameterOptimizer.getParameterValueToTry(parameterValuesToTry, test, prop);
                String string = parameterValue.toString();
                log.info("Setting {}={}", (Object)property, (Object)string);
                System.setProperty(property, string);
                testResultLine.append('[').append(property).append('=').append(string).append("] ");
            }
            try {
                testValue = this.evaluator.call().doubleValue();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            testResultLine.append("= ").append(testValue);
            testResultLinesByValue.add(new Pair<Double, String>(testValue, testResultLine.toString()));
            log.info("{}", (Object)testResultLine);
            if (this.minimize ? testValue < bestValue : testValue > bestValue) {
                log.info("New best value {}", (Object)testValue);
                bestValue = testValue;
                for (int prop = 0; prop < numProperties; ++prop) {
                    String string = propertyNames[prop];
                    Number parameterValue = ParameterOptimizer.getParameterValueToTry(parameterValuesToTry, test, prop);
                    bestParameterValues.put(string, parameterValue);
                }
            }
            Collections.sort(testResultLinesByValue, new Comparator<Pair<Double, String>>(){

                @Override
                public int compare(Pair<Double, String> a, Pair<Double, String> b) {
                    if (a.getFirst() > b.getFirst()) {
                        return -1;
                    }
                    if (a.getFirst() < b.getFirst()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (Pair pair : testResultLinesByValue) {
                log.info("{}", pair.getSecond());
            }
            log.info("Best parameter values so far are {}", (Object)bestParameterValues);
        }
        log.info("Final best parameter values are {}", (Object)bestParameterValues);
        return bestParameterValues;
    }

    private static Number getParameterValueToTry(Number[][] parameterValuesToTry, int test, int prop) {
        int whichValueToTry = test;
        for (int i = 0; i < prop; ++i) {
            whichValueToTry /= parameterValuesToTry[i].length;
        }
        return parameterValuesToTry[prop][whichValueToTry %= parameterValuesToTry[prop].length];
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("Usage: dataDirectory numSteps evaluationPercentage property=min:max [property2=min2:max2 ...]");
            return;
        }
        final File dataDir = new File(args[0]);
        Preconditions.checkArgument(dataDir.exists() && dataDir.isDirectory(), "Not a directory: %s", dataDir);
        Preconditions.checkArgument(dataDir.listFiles().length > 0, "No files in: %s", dataDir);
        int numSteps = Integer.parseInt(args[1]);
        Preconditions.checkArgument(numSteps >= 2, "# steps must be at least 2: %s", numSteps);
        final double evaluationPercentage = Double.parseDouble(args[2]);
        Preconditions.checkArgument(evaluationPercentage > 0.0 && evaluationPercentage <= 1.0, "evaluationPercentage must be in (0,1]: %s", evaluationPercentage);
        HashMap<String, ParameterRange> parameterRanges = Maps.newHashMapWithExpectedSize(args.length);
        for (int i = 3; i < args.length; ++i) {
            ParameterRange range;
            String[] propValue = EQUALS.split(args[i]);
            String systemProperty = propValue[0];
            String[] minMax = COLON.split(propValue[1]);
            try {
                int min = Integer.parseInt(minMax[0]);
                int max = Integer.parseInt(minMax.length == 1 ? minMax[0] : minMax[1]);
                range = new ParameterRange(min, max);
            }
            catch (NumberFormatException ignored) {
                double min = Double.parseDouble(minMax[0]);
                double max = Double.parseDouble(minMax.length == 1 ? minMax[0] : minMax[1]);
                range = new ParameterRange(min, max);
            }
            parameterRanges.put(systemProperty, range);
        }
        Callable<Number> evaluator = new Callable<Number>(){

            @Override
            public Number call() throws IOException, TasteException, InterruptedException {
                PrecisionRecallEvaluator prEvaluator = new PrecisionRecallEvaluator();
                MyrrixIRStatistics stats = (MyrrixIRStatistics)((Object)prEvaluator.evaluate(dataDir, 0.9, evaluationPercentage, null));
                return stats.getMeanAveragePrecision();
            }
        };
        ParameterOptimizer optimizer = new ParameterOptimizer(parameterRanges, numSteps, (Callable<? extends Number>)evaluator, false);
        Map<String, Number> optimalValues = optimizer.findGoodParameterValues();
        System.out.println(optimalValues);
    }
}

