% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points2plane.r
\name{mirror2plane}
\alias{mirror2plane}
\alias{mirror2plane.matrix}
\alias{mirror2plane.mesh3d}
\title{mirror points or mesh on an arbitrary plane}
\usage{
mirror2plane(x, v1, normal = NULL, v2 = NULL, v3 = NULL)

\method{mirror2plane}{matrix}(x, v1, normal = NULL, v2 = NULL, v3 = NULL)

\method{mirror2plane}{mesh3d}(x, v1, normal = NULL, v2 = NULL, v3 = NULL)
}
\arguments{
\item{x}{x 3D-vector or a k x 3 matrix with 3D vectors stored in rows. Or a triangular mesh of class mesh3d}

\item{v1}{point on plane}

\item{normal}{plane normal (overrides specification by v2 and v3)}

\item{v2}{if pNorm=NULL, the plane will be defined by three points \code{v1, v2, v3}}

\item{v3}{if pNorm=NULL, the plane will be defined by three points \code{v1, v2, v3}}
}
\value{
mirrored coordinates mesh
}
\description{
mirror points or mesh on an arbitrary plane
}
\examples{
# mirror mesh on plane spanned by 3 midsagital landmarks
data(boneData)
mirrmesh <- mirror2plane(skull_0144_ch_fe.mesh,v1=boneLM[1,,1],v2=boneLM[9,,1],v3=boneLM[10,,1])
}
