% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omega.full.SS.R
\name{omega.full.SS}
\alias{omega.full.SS}
\title{Omega Squared for One-Way and Multi-Way ANOVA from F}
\usage{
omega.full.SS(dfm, dfe, msm, mse, sst, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{msm}{mean square for the model/IV/between}

\item{mse}{mean square for the error/residual/within}

\item{sst}{sum of squares total}

\item{a}{significance level}
}
\value{
Provides omega squared with associated confidence intervals
and relevant statistics.

\item{omega}{omega squared}
\item{omegalow}{lower level confidence interval of omega}
\item{omegahigh}{upper level confidence interval of omega}
\item{dfm}{degrees of freedom for the model/IV/between}
\item{dfe}{degrees of freedom for the error/resisual/within}
\item{F}{F-statistic}
\item{p}{p-value}
\item{estimate}{the omega squared statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the F-statistic in APA style for markdown printing}
}
\description{
This function displays omega squared from ANOVA analyses
and its non-central confidence interval based on the F distribution.
This formula works for one way and multi way designs with careful
focus on which error term you are using for the calculation.
}
\details{
Omega squared is calculated by deducting the mean square of the error
from the mean square of the model and multiplying by the degrees of freedom for the model.
This is divided by the sum of the sum of squares total and the mean square of the error.

omega = (dfm * (msm - mse)) / (sst + mse)

\href{https://www.aggieerin.com/shiny-server/tests/omegass.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "bn1_data" dataset, included
#in the MOTE library.

#A health psychologist recorded the number of close inter-personal
#attachments of 45-year-olds who were in excellent, fair, or poor
#health. People in the Excellent Health group had 4, 3, 2, and 3
#close attachments; people in the Fair Health group had 3, 5,
#and 8 close attachments; and people in the Poor Health group
#had 3, 1, 0, and 2 close attachments.

anova_model = lm(formula = friends ~ group, data = bn1_data)
summary.aov(anova_model)

omega.full.SS(dfm = 2, dfe = 8,
              msm = 12.621, mse = 2.548,
              sst = (25.54+19.67), a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{omega,}
\keyword{size,}
