% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAIVE-package.R
\docType{package}
\name{MAIVE-package}
\alias{MAIVE}
\alias{MAIVE-package}
\title{MAIVE: Meta Analysis Instrumental Variable Estimator}
\description{
Meta-analysis traditionally assigns more weight to studies with lower standard errors, assuming higher precision. However, in observational research, precision must be estimated and is vulnerable to manipulation, such as p-hacking, to achieve statistical significance. This can lead to spurious precision, invalidating inverse-variance weighting and bias-correction methods like funnel plots. Common methods for addressing publication bias, including selection models, often fail or exacerbate the problem. This package introduces an instrumental variable approach to limit bias caused by spurious precision in meta-analysis. Methods are described in 'Irsova et al.' (2025) \doi{10.1038/s41467-025-63261-0}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://meta-analysis.cz/maive/}
  \item \url{https://github.com/meta-analysis-es/maive}
  \item Report bugs at \url{https://github.com/meta-analysis-es/maive/issues}
}

}
\author{
\strong{Maintainer}: Petr Cala \email{cala.p@seznam.cz} (Charles University, Prague)

Authors:
\itemize{
  \item Zuzana Irsova (Charles University, Prague)
  \item Pedro R. D. Bom (University of Deusto, Bilbao)
  \item Tomas Havranek (Charles University, Prague; CEPR, London; METRICS, Stanford)
  \item Heiko Rachinger (University of the Balearic Islands, Palma)
}

}
\keyword{internal}
