% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_datasets.R
\name{join_datasets}
\alias{join_datasets}
\title{Join similar Datasets}
\usage{
join_datasets(
  ...,
  Datetime.column = Datetime,
  Id.column = Id,
  add.origin = FALSE,
  debug = FALSE
)
}
\arguments{
\item{...}{\verb{Object names} of datasets that need to be joined.}

\item{Datetime.column, Id.column}{Column names for the \code{Datetime} and \code{id} columns. The defaults (\code{Datetime}, \code{Id}) are already set up for data imported with \link{LightLogR}.}

\item{add.origin}{Should a column named \code{dataset} in the joined data indicate from which dataset each observation originated? Defaults to \code{FALSE} as the \code{Id} column should suffice. Expects a \code{logical}.}

\item{debug}{Output changes to a tibble indicating which dataset is missing the respective \code{Datetime} or \code{Id} column. Expects a \code{logical} and defaults to \code{FALSE}.}
}
\value{
One of
\itemize{
\item a \code{data.frame} of joined datasets
\item a \code{tibble} of datasets with missing columns. Only if \code{debug = TRUE}
}
}
\description{
Join Light logging datasets that have a common structure. The least commonality are identical columns for \code{Datetime} and \code{Id} across all sets.
}
\examples{
#load in two datasets
path <- system.file("extdata", 
package = "LightLogR")
file.LL <- "205_actlumus_Log_1020_20230904101707532.txt.zip"
file.env <- "cyepiamb_CW35_Log_1431_20230904081953614.txt.zip"
dataset.LL <- import$ActLumus(file.LL, path = path, auto.id = "^(\\\\d{3})")
dataset.env <- import$ActLumus(file.env, path = path, manual.id = "CW35")

#join the datasets
joined <- join_datasets(dataset.LL, dataset.env)

#compare the number of rows
nrow(dataset.LL) + nrow(dataset.env) == nrow(joined)

#debug, when set to TRUE, will output a tibble of datasets with missing necessary columns
dataset.LL <- dataset.LL \%>\% dplyr::select(-Datetime)
join_datasets(dataset.LL, dataset.env, debug = TRUE)
}
