/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix2D;

class SelectedDenseObjectMatrix1D
extends ObjectMatrix1D {
    private static final long serialVersionUID = 1L;
    protected Object[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseObjectMatrix1D(Object[] objectArray, int[] nArray) {
        this(nArray.length, objectArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseObjectMatrix1D(int n, Object[] objectArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = objectArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    public Object elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public Object getQuick(int n) {
        return this.elements[this.offset + this.offsets[this.zero + n * this.stride]];
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix1D objectMatrix1D) {
        if (objectMatrix1D instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D selectedDenseObjectMatrix1D = (SelectedDenseObjectMatrix1D)objectMatrix1D;
            return this.elements == selectedDenseObjectMatrix1D.elements;
        }
        if (objectMatrix1D instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D denseObjectMatrix1D = (DenseObjectMatrix1D)objectMatrix1D;
            return this.elements == denseObjectMatrix1D.elements;
        }
        return false;
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public ObjectMatrix1D like(int n) {
        return new DenseObjectMatrix1D(n);
    }

    public ObjectMatrix2D like2D(int n, int n2) {
        return new DenseObjectMatrix2D(n, n2);
    }

    public void setQuick(int n, Object object) {
        this.elements[this.offset + this.offsets[this.zero + n * this.stride]] = object;
    }

    public ObjectMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public ObjectMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected ObjectMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseObjectMatrix1D(this.elements, nArray);
    }
}

