/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.colt.matrix.tint.impl.WrapperIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultFirst;
import cern.jet.math.tint.IntPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseCCIntMatrix2D
extends WrapperIntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] columnPointers;
    protected int[] rowIndexes;
    protected int[] values;
    protected boolean rowIndexesSorted;

    public SparseCCIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray[0].length);
        this.assign(nArray);
    }

    public SparseCCIntMatrix2D(int n, int n2) {
        this(n, n2, (int)Math.min(10L * (long)n, Integer.MAX_VALUE));
    }

    public SparseCCIntMatrix2D(int n, int n2, int n3) {
        block2: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.rowIndexes = new int[n3];
        this.values = new int[n3];
        this.columnPointers = new int[n2 + 1];
    }

    public SparseCCIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int n3, boolean bl, boolean bl2) {
        int n4;
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (n3 == 0) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int n5 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n5];
        this.values = new int[n5];
        this.columnPointers = new int[n2 + 1];
        int[] nArray3 = new int[n2];
        for (n4 = 0; n4 < n5; ++n4) {
            int n6 = nArray2[n4];
            nArray3[n6] = nArray3[n6] + 1;
        }
        this.cumsum(this.columnPointers, nArray3, n2);
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = nArray2[n4];
            nArray3[n7] = nArray3[n7] + 1;
            this.rowIndexes[var10_12] = nArray[n4];
            this.values[var10_12] = n3;
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl2) {
            this.sortRowIndexes();
        }
    }

    public SparseCCIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        block8: {
            super(null);
            this.rowIndexesSorted = false;
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block8;
                throw illegalArgumentException;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (nArray.length != nArray3.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int n4 = Math.max(nArray.length, 1);
        this.rowIndexes = new int[n4];
        this.values = new int[n4];
        this.columnPointers = new int[n2 + 1];
        int[] nArray4 = new int[n2];
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = nArray2[n3];
            nArray4[n5] = nArray4[n5] + 1;
        }
        this.cumsum(this.columnPointers, nArray4, n2);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = nArray2[n3];
            nArray4[n6] = nArray4[n6] + 1;
            this.rowIndexes[var11_13] = nArray[n3];
            this.values[var11_13] = nArray3[n3];
        }
        if (bl) {
            this.removeDuplicates();
        }
        if (bl3) {
            this.sortRowIndexes();
        }
    }

    public IntMatrix2D assign(final IntFunction intFunction) {
        if (intFunction instanceof IntMult) {
            int n = ((IntMult)intFunction).multiplicator;
            if (n == 1) {
                return this;
            }
            if (n == 0) {
                return this.assign(0);
            }
            if (n != n) {
                return this.assign(n);
            }
            int[] nArray = this.values;
            int n2 = this.cardinality();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3++;
                nArray[n4] = nArray[n4] * n;
            }
        } else {
            this.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n, int n2, int n3) {
                    return intFunction.apply(n3);
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(int n) {
        if (n == 0) {
            Arrays.fill(this.rowIndexes, 0);
            Arrays.fill(this.columnPointers, 0);
            Arrays.fill(this.values, 0);
        } else {
            int n2 = this.cardinality();
            for (int i = 0; i < n2; ++i) {
                this.values[i] = n;
            }
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (intMatrix2D == this) {
            return this;
        }
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof SparseCCIntMatrix2D) {
            SparseCCIntMatrix2D sparseCCIntMatrix2D = (SparseCCIntMatrix2D)intMatrix2D;
            System.arraycopy(sparseCCIntMatrix2D.getColumnPointers(), 0, this.columnPointers, 0, this.columns + 1);
            int n = sparseCCIntMatrix2D.getRowIndexes().length;
            if (this.rowIndexes.length < n) {
                this.rowIndexes = new int[n];
                this.values = new int[n];
            }
            System.arraycopy(sparseCCIntMatrix2D.getRowIndexes(), 0, this.rowIndexes, 0, n);
            System.arraycopy(sparseCCIntMatrix2D.getValues(), 0, this.values, 0, n);
            this.rowIndexesSorted = sparseCCIntMatrix2D.rowIndexesSorted;
        } else if (intMatrix2D instanceof SparseRCIntMatrix2D) {
            SparseRCIntMatrix2D sparseRCIntMatrix2D = ((SparseRCIntMatrix2D)intMatrix2D).getTranspose();
            this.columnPointers = sparseRCIntMatrix2D.getRowPointers();
            this.rowIndexes = sparseRCIntMatrix2D.getColumnIndexes();
            this.values = sparseRCIntMatrix2D.getValues();
            this.rowIndexesSorted = true;
        } else {
            this.assign(0);
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n, int n2, int n3) {
                    SparseCCIntMatrix2D.this.setQuick(n, n2, n3);
                    return n3;
                }
            });
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D, IntIntFunction intIntFunction) {
        this.checkShape(intMatrix2D);
        if (intMatrix2D instanceof SparseCCIntMatrix2D && intIntFunction == IntFunctions.plus) {
            SparseCCIntMatrix2D sparseCCIntMatrix2D = (SparseCCIntMatrix2D)intMatrix2D;
            int n = 0;
            int n2 = this.rows;
            int n3 = this.columnPointers[this.columns];
            int n4 = sparseCCIntMatrix2D.columns;
            int[] nArray = sparseCCIntMatrix2D.columnPointers;
            int n5 = nArray[n4];
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            SparseCCIntMatrix2D sparseCCIntMatrix2D2 = new SparseCCIntMatrix2D(n2, n4, n3 + n5);
            int[] nArray4 = sparseCCIntMatrix2D2.columnPointers;
            int[] nArray5 = sparseCCIntMatrix2D2.rowIndexes;
            int[] nArray6 = sparseCCIntMatrix2D2.values;
            for (int i = 0; i < n4; ++i) {
                nArray4[i] = n;
                n = this.scatter(this, i, 1, nArray2, nArray3, i + 1, sparseCCIntMatrix2D2, n);
                n = this.scatter(sparseCCIntMatrix2D, i, 1, nArray2, nArray3, i + 1, sparseCCIntMatrix2D2, n);
                for (int j = nArray4[i]; j < n; ++j) {
                    nArray6[j] = nArray3[nArray5[j]];
                }
            }
            nArray4[n4] = n;
            this.rowIndexes = nArray5;
            this.columnPointers = nArray4;
            this.values = nArray6;
            return this;
        }
        if (intIntFunction instanceof IntPlusMultSecond) {
            final int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n == 0) {
                return this;
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    SparseCCIntMatrix2D.this.setQuick(n4, n2, SparseCCIntMatrix2D.this.getQuick(n4, n2) + n * n3);
                    return n3;
                }
            });
            return this;
        }
        if (intIntFunction instanceof IntPlusMultFirst) {
            final int n = ((IntPlusMultFirst)intIntFunction).multiplicator;
            if (n == 0) {
                return this.assign(intMatrix2D);
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    SparseCCIntMatrix2D.this.setQuick(n4, n2, n * SparseCCIntMatrix2D.this.getQuick(n4, n2) + n3);
                    return n3;
                }
            });
            return this;
        }
        if (intIntFunction == IntFunctions.mult) {
            int[] nArray = this.rowIndexes;
            int[] nArray7 = this.columnPointers;
            int[] nArray8 = this.values;
            int n = this.columns;
            while (--n >= 0) {
                int n6 = nArray7[n];
                int n7 = nArray7[n + 1];
                while (--n7 >= n6) {
                    int n8 = nArray[n7];
                    int n9 = n7;
                    nArray8[n9] = nArray8[n9] * intMatrix2D.getQuick(n8, n);
                    if (nArray8[n7] != 0) continue;
                    this.remove(n8, n);
                }
            }
            return this;
        }
        if (intIntFunction == IntFunctions.div) {
            int[] nArray = this.rowIndexes;
            int[] nArray9 = this.columnPointers;
            int[] nArray10 = this.values;
            int n = this.columns;
            while (--n >= 0) {
                int n10 = nArray9[n];
                int n11 = nArray9[n + 1];
                while (--n11 >= n10) {
                    int n12 = nArray[n11];
                    int n13 = n11;
                    nArray10[n13] = nArray10[n13] / intMatrix2D.getQuick(n12, n);
                    if (nArray10[n11] != 0) continue;
                    this.remove(n12, n);
                }
            }
            return this;
        }
        return super.assign(intMatrix2D, intIntFunction);
    }

    public int cardinality() {
        return this.columnPointers[this.columns];
    }

    public IntMatrix2D forEachNonZero(IntIntIntFunction intIntIntFunction) {
        int[] nArray = this.rowIndexes;
        int[] nArray2 = this.columnPointers;
        int[] nArray3 = this.values;
        int n = this.columns;
        while (--n >= 0) {
            int n2 = nArray2[n];
            int n3 = nArray2[n + 1];
            while (--n3 >= n2) {
                int n4;
                int n5 = nArray[n3];
                int n6 = nArray3[n3];
                nArray3[n3] = n4 = intIntIntFunction.apply(n5, n, n6);
            }
        }
        return this;
    }

    public int[] getColumnPointers() {
        return this.columnPointers;
    }

    public DenseIntMatrix2D getDense() {
        final DenseIntMatrix2D denseIntMatrix2D = new DenseIntMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntIntFunction(){

            public int apply(int n, int n2, int n3) {
                denseIntMatrix2D.setQuick(n, n2, SparseCCIntMatrix2D.this.getQuick(n, n2));
                return n3;
            }
        });
        return denseIntMatrix2D;
    }

    public synchronized int getQuick(int n, int n2) {
        int n3 = SparseCCIntMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        int n4 = 0;
        if (n3 >= 0) {
            n4 = this.values[n3];
        }
        return n4;
    }

    public SparseRCIntMatrix2D getRowCompressed() {
        SparseCCIntMatrix2D sparseCCIntMatrix2D = this.getTranspose();
        SparseRCIntMatrix2D sparseRCIntMatrix2D = new SparseRCIntMatrix2D(this.rows, this.columns);
        sparseRCIntMatrix2D.columnIndexes = sparseCCIntMatrix2D.rowIndexes;
        sparseRCIntMatrix2D.rowPointers = sparseCCIntMatrix2D.columnPointers;
        sparseRCIntMatrix2D.values = sparseCCIntMatrix2D.values;
        sparseRCIntMatrix2D.columnIndexesSorted = true;
        return sparseRCIntMatrix2D;
    }

    public int[] getRowIndexes() {
        return this.rowIndexes;
    }

    public SparseCCIntMatrix2D getTranspose() {
        int n;
        int n2 = this.rows;
        int n3 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        int[] nArray3 = this.values;
        SparseCCIntMatrix2D sparseCCIntMatrix2D = new SparseCCIntMatrix2D(this.columns, this.rows, nArray2.length);
        int[] nArray4 = new int[n2];
        int[] nArray5 = sparseCCIntMatrix2D.columnPointers;
        int[] nArray6 = sparseCCIntMatrix2D.rowIndexes;
        int[] nArray7 = sparseCCIntMatrix2D.values;
        for (n = 0; n < nArray[n3]; ++n) {
            int n4 = nArray2[n];
            nArray4[n4] = nArray4[n4] + 1;
        }
        this.cumsum(nArray5, nArray4, n2);
        for (int i = 0; i < n3; ++i) {
            for (n = nArray[i]; n < nArray[i + 1]; ++n) {
                int n5 = nArray2[n];
                nArray4[n5] = nArray4[n5] + 1;
                nArray6[var2_13] = i;
                nArray7[var2_13] = nArray3[n];
            }
        }
        return sparseCCIntMatrix2D;
    }

    public int[] getValues() {
        return this.values;
    }

    public boolean hasRowIndexesSorted() {
        return this.rowIndexesSorted;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseCCIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        int n4 = SparseCCIntMatrix2D.searchFromTo(this.rowIndexes, n, this.columnPointers[n2], this.columnPointers[n2 + 1] - 1);
        if (n4 >= 0) {
            if (n3 == 0) {
                this.remove(n2, n4);
            } else {
                this.values[n4] = n3;
            }
            return;
        }
        if (n3 != 0) {
            n4 = -n4 - 1;
            this.insert(n, n2, n4, n3);
        }
    }

    public void sortRowIndexes() {
        SparseCCIntMatrix2D sparseCCIntMatrix2D = this.getTranspose();
        sparseCCIntMatrix2D = sparseCCIntMatrix2D.getTranspose();
        this.columnPointers = sparseCCIntMatrix2D.columnPointers;
        this.rowIndexes = sparseCCIntMatrix2D.rowIndexes;
        this.values = sparseCCIntMatrix2D.values;
        this.rowIndexesSorted = true;
    }

    public void removeDuplicates() {
        int n;
        int n2 = 0;
        int n3 = this.rows;
        int n4 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        int[] nArray3 = this.values;
        int[] nArray4 = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray4[n] = -1;
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = n2;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                n = nArray2[j];
                if (nArray4[n] >= n5) {
                    int n6 = nArray4[n];
                    nArray3[n6] = nArray3[n6] + nArray3[j];
                    continue;
                }
                nArray4[n] = n2;
                nArray2[n2] = n;
                nArray3[n2++] = nArray3[j];
            }
            nArray[i] = n5;
        }
        nArray[n4] = n2;
    }

    public void removeZeroes() {
        int n = 0;
        int n2 = this.columns;
        int[] nArray = this.columnPointers;
        int[] nArray2 = this.rowIndexes;
        int[] nArray3 = this.values;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
            for (int j = nArray[i]; j < nArray[i + 1]; ++j) {
                if (nArray3[j] == 0) continue;
                nArray3[n] = nArray3[j];
                nArray2[n++] = nArray2[j];
            }
        }
        nArray[n2] = n;
    }

    public void trimToSize() {
        this.realloc(0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.columns; ++i) {
            int n = this.columnPointers[i + 1];
            for (int j = this.columnPointers[i]; j < n; ++j) {
                stringBuilder.append('(').append(this.rowIndexes[j]).append(',').append(i).append(')').append('\t').append(this.values[j]).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, final int n, final int n2, boolean bl) {
        boolean bl2;
        int n3 = bl ? this.columns : this.rows;
        int n4 = bl ? this.rows : this.columns;
        boolean bl3 = bl2 = intMatrix1D2 == null || bl;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n3);
        }
        if (!(intMatrix1D instanceof DenseIntMatrix1D) || !(intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2, n, n2, bl);
        }
        if ((long)n4 != intMatrix1D.size() || (long)n3 > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        final int[] nArray = denseIntMatrix1D.elements;
        final int n5 = denseIntMatrix1D.stride();
        final int n6 = (int)denseIntMatrix1D.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray2 = denseIntMatrix1D2.elements;
        final int n7 = denseIntMatrix1D2.stride();
        final int n8 = (int)denseIntMatrix1D2.index(0);
        final int[] nArray3 = this.rowIndexes;
        final int[] nArray4 = this.columnPointers;
        final int[] nArray5 = this.values;
        int n9 = n6;
        int n10 = ConcurrencyUtils.getNumberOfThreads();
        if (!bl) {
            if (!bl2 && n2 != 1) {
                intMatrix1D2.assign(IntFunctions.mult(n2));
            }
            if (n10 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int n11;
                int n12;
                n10 = 2;
                Future[] futureArray = new Future[n10];
                final int[] nArray6 = new int[n3];
                int n13 = this.columns / n10;
                for (n12 = 0; n12 < n10; ++n12) {
                    n11 = n12 * n13;
                    final int n14 = n12 == n10 - 1 ? this.columns : n11 + n13;
                    final int n15 = n12;
                    futureArray[n12] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            if (n15 == 0) {
                                for (int i = n11; i < n14; ++i) {
                                    int n9 = nArray4[i + 1];
                                    int n2 = nArray2[n8 + n7 * i];
                                    for (int j = nArray4[i]; j < n9; ++j) {
                                        int n3 = nArray3[j];
                                        int n4 = n6 + n5 * n3;
                                        nArray[n4] = nArray[n4] + n * nArray5[j] * n2;
                                    }
                                }
                            } else {
                                for (int i = n11; i < n14; ++i) {
                                    int n10 = nArray4[i + 1];
                                    int n52 = nArray2[n8 + n7 * i];
                                    for (int j = nArray4[i]; j < n10; ++j) {
                                        int n62;
                                        int n72 = n62 = nArray3[j];
                                        nArray6[n72] = nArray6[n72] + n * nArray5[j] * n52;
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                for (n11 = n12 = n3 % 10; n11 < n3; n11 += 10) {
                    int n16 = n6 + n11 * n5;
                    nArray[n16] = nArray[n16] + nArray6[n11];
                    int n17 = n6 + (n11 + 1) * n5;
                    nArray[n17] = nArray[n17] + nArray6[n11 + 1];
                    int n18 = n6 + (n11 + 2) * n5;
                    nArray[n18] = nArray[n18] + nArray6[n11 + 2];
                    int n19 = n6 + (n11 + 3) * n5;
                    nArray[n19] = nArray[n19] + nArray6[n11 + 3];
                    int n20 = n6 + (n11 + 4) * n5;
                    nArray[n20] = nArray[n20] + nArray6[n11 + 4];
                    int n21 = n6 + (n11 + 5) * n5;
                    nArray[n21] = nArray[n21] + nArray6[n11 + 5];
                    int n22 = n6 + (n11 + 6) * n5;
                    nArray[n22] = nArray[n22] + nArray6[n11 + 6];
                    int n23 = n6 + (n11 + 7) * n5;
                    nArray[n23] = nArray[n23] + nArray6[n11 + 7];
                    int n24 = n6 + (n11 + 8) * n5;
                    nArray[n24] = nArray[n24] + nArray6[n11 + 8];
                    int n25 = n6 + (n11 + 9) * n5;
                    nArray[n25] = nArray[n25] + nArray6[n11 + 9];
                }
                for (n11 = 0; n11 < n12; ++n11) {
                    int n26 = n6 + n11 * n5;
                    nArray[n26] = nArray[n26] + nArray6[n11];
                }
            } else {
                for (int i = 0; i < this.columns; ++i) {
                    int n27 = nArray4[i + 1];
                    int n28 = nArray2[n8 + n7 * i];
                    for (int j = nArray4[i]; j < n27; ++j) {
                        int n29 = nArray3[j];
                        int n30 = n6 + n5 * n29;
                        nArray[n30] = nArray[n30] + n * nArray5[j] * n28;
                    }
                }
            }
        } else if (n10 > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            Future[] futureArray = new Future[n10];
            int n31 = this.columns / n10;
            for (int i = 0; i < n10; ++i) {
                final int n32 = i * n31;
                final int n33 = i == n10 - 1 ? this.columns : n32 + n31;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n6 + n32 * n5;
                        int n22 = SparseCCIntMatrix2D.this.columnPointers[n32];
                        for (int i = n32; i < n33; ++i) {
                            int n3 = 0;
                            int n4 = SparseCCIntMatrix2D.this.columnPointers[i + 1];
                            while (n22 + 10 < n4) {
                                int n52 = n22 + 9;
                                n3 += nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]] + nArray5[n52] * nArray2[n8 + n7 * SparseCCIntMatrix2D.this.rowIndexes[n52--]];
                                n22 += 10;
                            }
                            while (n22 < n4) {
                                n3 += nArray5[n22] * nArray2[SparseCCIntMatrix2D.this.rowIndexes[n22]];
                                ++n22;
                            }
                            nArray[n9] = n * n3 + n2 * nArray[n9];
                            n9 += n5;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n34 = this.columnPointers[0];
            for (int i = 0; i < this.columns; ++i) {
                int n35 = 0;
                int n36 = this.columnPointers[i + 1];
                while (n34 + 10 < n36) {
                    int n37 = n34 + 9;
                    n35 += nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]] + nArray5[n37] * nArray2[n8 + n7 * this.rowIndexes[n37--]];
                    n34 += 10;
                }
                while (n34 < n36) {
                    n35 += nArray5[n34] * nArray2[this.rowIndexes[n34]];
                    ++n34;
                }
                nArray[n9] = n * n35 + n2 * nArray[n9];
                n9 += n5;
            }
        }
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        int n5 = intMatrix2D.rows();
        int n6 = intMatrix2D.columns();
        if (bl2) {
            n5 = intMatrix2D.columns();
            n6 = intMatrix2D.rows();
        }
        int n7 = n6;
        boolean bl4 = bl3 = intMatrix2D2 == null;
        if (intMatrix2D2 == null) {
            intMatrix2D2 = intMatrix2D instanceof SparseCCIntMatrix2D ? new SparseCCIntMatrix2D(n3, n7, n3 * n7) : new DenseIntMatrix2D(n3, n7);
        }
        if (n5 != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort());
        }
        if (intMatrix2D2.rows() != n3 || intMatrix2D2.columns() != n7) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3 && (double)n2 != 1.0) {
            intMatrix2D2.assign(IntFunctions.mult(n2));
        }
        if (intMatrix2D instanceof DenseIntMatrix2D && intMatrix2D2 instanceof DenseIntMatrix2D) {
            SparseCCIntMatrix2D sparseCCIntMatrix2D = bl ? this.getTranspose() : this;
            DenseIntMatrix2D denseIntMatrix2D = bl2 ? (DenseIntMatrix2D)intMatrix2D.viewDice() : (DenseIntMatrix2D)intMatrix2D;
            DenseIntMatrix2D denseIntMatrix2D2 = (DenseIntMatrix2D)intMatrix2D2;
            int[] nArray = sparseCCIntMatrix2D.columnPointers;
            int[] nArray2 = sparseCCIntMatrix2D.rowIndexes;
            int[] nArray3 = sparseCCIntMatrix2D.values;
            int n8 = (int)denseIntMatrix2D.index(0, 0);
            int n9 = denseIntMatrix2D.rowStride();
            int n10 = denseIntMatrix2D.columnStride();
            int[] nArray4 = denseIntMatrix2D.elements;
            int n11 = (int)denseIntMatrix2D2.index(0, 0);
            int n12 = denseIntMatrix2D2.rowStride();
            int n13 = denseIntMatrix2D2.columnStride();
            int[] nArray5 = denseIntMatrix2D2.elements;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n14 = nArray[j + 1];
                    int n15 = nArray4[n8 + j * n9 + i * n10];
                    for (int k = nArray[j]; k < n14; ++k) {
                        int n16 = nArray2[k];
                        int n17 = n11 + n16 * n12 + i * n13;
                        nArray5[n17] = nArray5[n17] + nArray3[k] * n15;
                    }
                }
            }
            if ((double)n != 1.0) {
                intMatrix2D2.assign(IntFunctions.mult(n));
            }
        } else if (intMatrix2D instanceof SparseCCIntMatrix2D && intMatrix2D2 instanceof SparseCCIntMatrix2D) {
            SparseCCIntMatrix2D sparseCCIntMatrix2D = bl ? this.getTranspose() : this;
            SparseCCIntMatrix2D sparseCCIntMatrix2D2 = (SparseCCIntMatrix2D)intMatrix2D;
            if (bl2) {
                sparseCCIntMatrix2D2 = sparseCCIntMatrix2D2.getTranspose();
            }
            SparseCCIntMatrix2D sparseCCIntMatrix2D3 = (SparseCCIntMatrix2D)intMatrix2D2;
            int n18 = 0;
            int n19 = n3;
            int n20 = n6;
            int[] nArray = sparseCCIntMatrix2D2.columnPointers;
            int[] nArray6 = sparseCCIntMatrix2D2.rowIndexes;
            int[] nArray7 = sparseCCIntMatrix2D2.values;
            int[] nArray8 = new int[n19];
            int[] nArray9 = new int[n19];
            int[] nArray10 = sparseCCIntMatrix2D3.columnPointers;
            int[] nArray11 = sparseCCIntMatrix2D3.rowIndexes;
            int[] nArray12 = sparseCCIntMatrix2D3.values;
            for (int i = 0; i < n20; ++i) {
                int n21 = sparseCCIntMatrix2D3.rowIndexes.length;
                if (n18 + n19 > n21) {
                    n21 = 2 * n21 + n19;
                    int[] nArray13 = new int[n21];
                    System.arraycopy(nArray11, 0, nArray13, 0, nArray11.length);
                    nArray11 = nArray13;
                    int[] nArray14 = new int[n21];
                    System.arraycopy(nArray12, 0, nArray14, 0, nArray12.length);
                    nArray12 = nArray14;
                }
                nArray10[i] = n18;
                for (n7 = nArray[i]; n7 < nArray[i + 1]; ++n7) {
                    n18 = this.scatter(sparseCCIntMatrix2D, nArray6[n7], nArray7[n7], nArray8, nArray9, i + 1, sparseCCIntMatrix2D3, n18);
                }
                for (n7 = nArray10[i]; n7 < n18; ++n7) {
                    nArray12[n7] = nArray9[nArray11[n7]];
                }
            }
            nArray10[n20] = n18;
            if ((double)n != 1.0) {
                sparseCCIntMatrix2D3.assign(IntFunctions.mult(n));
            }
        } else {
            if (bl2) {
                intMatrix2D = intMatrix2D.viewDice();
            }
            IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[n4];
            int n22 = n4;
            while (--n22 >= 0) {
                intMatrix1DArray[n22] = intMatrix2D.viewRow(n22);
            }
            IntMatrix1D[] intMatrix1DArray2 = new IntMatrix1D[n3];
            int n23 = n3;
            while (--n23 >= 0) {
                intMatrix1DArray2[n23] = intMatrix2D2.viewRow(n23);
            }
            IntPlusMultSecond intPlusMultSecond = IntPlusMultSecond.plusMult(0);
            int[] nArray = this.rowIndexes;
            int[] nArray15 = this.columnPointers;
            int[] nArray16 = this.values;
            int n24 = this.columns;
            while (--n24 >= 0) {
                int n25 = nArray15[n24];
                int n26 = nArray15[n24 + 1];
                while (--n26 >= n25) {
                    int n27 = nArray[n26];
                    intPlusMultSecond.multiplicator = nArray16[n26] * n;
                    if (!bl) {
                        intMatrix1DArray2[n27].assign(intMatrix1DArray[n24], intPlusMultSecond);
                        continue;
                    }
                    intMatrix1DArray2[n24].assign(intMatrix1DArray[n27], intPlusMultSecond);
                }
            }
        }
        return intMatrix2D2;
    }

    protected IntMatrix2D getContent() {
        return this;
    }

    protected void insert(int n, int n2, int n3, int n4) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        intArrayList.setSizeRaw(this.columnPointers[this.columns]);
        IntArrayList intArrayList2 = new IntArrayList(this.values);
        intArrayList2.setSizeRaw(this.columnPointers[this.columns]);
        intArrayList.beforeInsert(n3, n);
        intArrayList2.beforeInsert(n3, n4);
        int n5 = this.columnPointers.length;
        while (--n5 > n2) {
            int n6 = n5;
            this.columnPointers[n6] = this.columnPointers[n6] + 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = intArrayList2.elements();
    }

    protected void remove(int n, int n2) {
        IntArrayList intArrayList = new IntArrayList(this.rowIndexes);
        IntArrayList intArrayList2 = new IntArrayList(this.values);
        intArrayList.remove(n2);
        intArrayList2.remove(n2);
        int n3 = this.columnPointers.length;
        while (--n3 > n) {
            int n4 = n3;
            this.columnPointers[n4] = this.columnPointers[n4] - 1;
        }
        this.rowIndexes = intArrayList.elements();
        this.values = intArrayList2.elements();
    }

    private static int searchFromTo(int[] nArray, int n, int n2, int n3) {
        while (n2 <= n3) {
            if (nArray[n2] == n) {
                return n2;
            }
            ++n2;
        }
        return -(n2 + 1);
    }

    private int cumsum(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = n2;
            n2 += nArray2[i];
            n3 += nArray2[i];
            nArray2[i] = nArray[i];
        }
        nArray[n] = n2;
        return n3;
    }

    private void realloc(int n) {
        if (n <= 0) {
            n = this.columnPointers[this.columns];
        }
        int[] nArray = new int[n];
        int n2 = Math.min(n, this.rowIndexes.length);
        System.arraycopy(this.rowIndexes, 0, nArray, 0, n2);
        this.rowIndexes = nArray;
        int[] nArray2 = new int[n];
        n2 = Math.min(n, this.values.length);
        System.arraycopy(this.values, 0, nArray2, 0, n2);
        this.values = nArray2;
    }

    private int scatter(SparseCCIntMatrix2D sparseCCIntMatrix2D, int n, int n2, int[] nArray, int[] nArray2, int n3, SparseCCIntMatrix2D sparseCCIntMatrix2D2, int n4) {
        int[] nArray3 = sparseCCIntMatrix2D.columnPointers;
        int[] nArray4 = sparseCCIntMatrix2D.rowIndexes;
        int[] nArray5 = sparseCCIntMatrix2D.values;
        int[] nArray6 = sparseCCIntMatrix2D2.rowIndexes;
        for (int i = nArray3[n]; i < nArray3[n + 1]; ++i) {
            int n5 = nArray4[i];
            if (nArray[n5] < n3) {
                nArray[n5] = n3;
                nArray6[n4++] = n5;
                if (nArray2 == null) continue;
                nArray2[n5] = n2 * nArray5[i];
                continue;
            }
            if (nArray2 == null) continue;
            int n6 = n5;
            nArray2[n6] = nArray2[n6] + n2 * nArray5[i];
        }
        return n4;
    }
}

