/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.impl.DenseColumnFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseCCFloatMatrix2D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseRCFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FloatProperty
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatProperty DEFAULT = new FloatProperty(1.0E-5f);
    public static final FloatProperty ZERO = new FloatProperty(0.0f);
    public static final FloatProperty SEVEN = new FloatProperty(1.0E-7f);
    protected float tolerance;

    private FloatProperty() {
        this(1.0E-5f);
    }

    public FloatProperty(float f) {
        this.tolerance = Math.abs(f);
    }

    protected static String blanks(int n) {
        if (n < 0) {
            n = 0;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void checkRectangular(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D.rows() < floatMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + AbstractFormatter.shape(floatMatrix2D));
        }
    }

    public void checkSquare(FloatMatrix2D floatMatrix2D) {
        if (floatMatrix2D.rows() != floatMatrix2D.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(floatMatrix2D));
        }
    }

    public void checkDense(FloatMatrix2D floatMatrix2D) {
        if (!(floatMatrix2D instanceof DenseFloatMatrix2D) && !(floatMatrix2D instanceof DenseColumnFloatMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkDense(FloatMatrix1D floatMatrix1D) {
        if (!(floatMatrix1D instanceof DenseFloatMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be dense");
        }
    }

    public void checkSparse(FloatMatrix1D floatMatrix1D) {
        if (!(floatMatrix1D instanceof SparseFloatMatrix1D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public void checkSparse(FloatMatrix2D floatMatrix2D) {
        if (!(floatMatrix2D instanceof SparseCCFloatMatrix2D) && !(floatMatrix2D instanceof SparseRCFloatMatrix2D)) {
            throw new IllegalArgumentException("Matrix must be sparse");
        }
    }

    public float density(FloatMatrix2D floatMatrix2D) {
        return (float)floatMatrix2D.cardinality() / (float)floatMatrix2D.size();
    }

    public boolean equals(final FloatMatrix1D floatMatrix1D, final float f) {
        if (floatMatrix1D == null) {
            return false;
        }
        int n = (int)floatMatrix1D.size();
        final float f2 = this.tolerance();
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n5; i < n6; ++i) {
                            float f3 = floatMatrix1D.getQuick(i);
                            float f22 = Math.abs(f - f3);
                            if (f22 != f22 && (f != f && f3 != f3 || f == f3)) {
                                f22 = 0.0f;
                            }
                            if (f22 <= f2) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            float f3 = floatMatrix1D.getQuick(i);
            float f4 = Math.abs(f - f3);
            if (f4 != f4 && (f != f && f3 != f3 || f == f3)) {
                f4 = 0.0f;
            }
            if (f4 <= f2) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final FloatMatrix1D floatMatrix1D, final FloatMatrix1D floatMatrix1D2) {
        if (floatMatrix1D == floatMatrix1D2) {
            return true;
        }
        if (floatMatrix1D == null || floatMatrix1D2 == null) {
            return false;
        }
        int n = (int)floatMatrix1D.size();
        if ((long)n != floatMatrix1D2.size()) {
            return false;
        }
        final float f = this.tolerance();
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n5; i < n6; ++i) {
                            float f4 = floatMatrix1D.getQuick(i);
                            float f2 = floatMatrix1D2.getQuick(i);
                            float f3 = Math.abs(f2 - f4);
                            if (f3 != f3 && (f2 != f2 && f4 != f4 || f2 == f4)) {
                                f3 = 0.0f;
                            }
                            if (f3 <= f) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            float f2 = floatMatrix1D.getQuick(i);
            float f3 = floatMatrix1D2.getQuick(i);
            float f4 = Math.abs(f3 - f2);
            if (f4 != f4 && (f3 != f3 && f2 != f2 || f3 == f2)) {
                f4 = 0.0f;
            }
            if (f4 <= f) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final FloatMatrix2D floatMatrix2D, final float f) {
        if (floatMatrix2D == null) {
            return false;
        }
        int n = floatMatrix2D.rows();
        final int n2 = floatMatrix2D.columns();
        boolean bl = false;
        final float f2 = this.tolerance();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && floatMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, floatMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = floatMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? floatMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                float f3 = floatMatrix2D.getQuick(i, j);
                                float f22 = Math.abs(f - f3);
                                if (f22 != f22 && (f != f && f3 != f3 || f == f3)) {
                                    f22 = 0.0f;
                                }
                                if (f22 <= f2) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f3 = floatMatrix2D.getQuick(i, j);
                float f4 = Math.abs(f - f3);
                if (f4 != f4 && (f != f && f3 != f3 || f == f3)) {
                    f4 = 0.0f;
                }
                if (f4 <= f2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FloatMatrix2D floatMatrix2D, final FloatMatrix2D floatMatrix2D2) {
        if (floatMatrix2D == floatMatrix2D2) {
            return true;
        }
        if (floatMatrix2D == null || floatMatrix2D2 == null) {
            return false;
        }
        int n = floatMatrix2D.rows();
        final int n2 = floatMatrix2D.columns();
        if (n2 != floatMatrix2D2.columns() || n != floatMatrix2D2.rows()) {
            return false;
        }
        boolean bl = false;
        final float f = this.tolerance();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && floatMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, floatMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = floatMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? floatMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                float f4 = floatMatrix2D.getQuick(i, j);
                                float f2 = floatMatrix2D2.getQuick(i, j);
                                float f3 = Math.abs(f2 - f4);
                                if (f3 != f3 && (f2 != f2 && f4 != f4 || f2 == f4)) {
                                    f3 = 0.0f;
                                }
                                if (f3 <= f) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                float f2 = floatMatrix2D.getQuick(i, j);
                float f3 = floatMatrix2D2.getQuick(i, j);
                float f4 = Math.abs(f3 - f2);
                if (f4 != f4 && (f3 != f3 && f2 != f2 || f3 == f2)) {
                    f4 = 0.0f;
                }
                if (f4 <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final FloatMatrix3D floatMatrix3D, final float f) {
        if (floatMatrix3D == null) {
            return false;
        }
        int n = floatMatrix3D.slices();
        final int n2 = floatMatrix3D.rows();
        final int n3 = floatMatrix3D.columns();
        boolean bl = false;
        final float f2 = this.tolerance();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && floatMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    float f3 = floatMatrix3D.getQuick(i, j, k);
                                    float f22 = Math.abs(f - f3);
                                    if (f22 != f22 && (f != f && f3 != f3 || f == f3)) {
                                        f22 = 0.0f;
                                    }
                                    if (f22 <= f2) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float f3 = floatMatrix3D.getQuick(i, j, k);
                    float f4 = Math.abs(f - f3);
                    if (f4 != f4 && (f != f && f3 != f3 || f == f3)) {
                        f4 = 0.0f;
                    }
                    if (f4 <= f2) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final FloatMatrix3D floatMatrix3D, final FloatMatrix3D floatMatrix3D2) {
        if (floatMatrix3D == floatMatrix3D2) {
            return true;
        }
        if (floatMatrix3D == null || floatMatrix3D2 == null) {
            return false;
        }
        int n = floatMatrix3D.slices();
        final int n2 = floatMatrix3D.rows();
        final int n3 = floatMatrix3D.columns();
        if (n3 != floatMatrix3D2.columns() || n2 != floatMatrix3D2.rows() || n != floatMatrix3D2.slices()) {
            return false;
        }
        boolean bl = false;
        final float f = this.tolerance();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && floatMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    float f4 = floatMatrix3D.getQuick(i, j, k);
                                    float f2 = floatMatrix3D2.getQuick(i, j, k);
                                    float f3 = Math.abs(f2 - f4);
                                    if (f3 != f3 && (f2 != f2 && f4 != f4 || f2 == f4)) {
                                        f3 = 0.0f;
                                    }
                                    if (f3 <= f) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    float f2 = floatMatrix3D.getQuick(i, j, k);
                    float f3 = floatMatrix3D2.getQuick(i, j, k);
                    float f4 = Math.abs(f3 - f2);
                    if (f4 != f4 && (f3 != f3 && f2 != f2 || f3 == f2)) {
                        f4 = 0.0f;
                    }
                    if (f4 <= f) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void generateNonSingular(FloatMatrix2D floatMatrix2D) {
        int n;
        this.checkSquare(floatMatrix2D);
        FloatFunctions floatFunctions = FloatFunctions.functions;
        int n2 = n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        while (--n2 >= 0) {
            floatMatrix2D.setQuick(n2, n2, 0.0f);
        }
        n2 = n;
        while (--n2 >= 0) {
            float f = floatMatrix2D.viewRow(n2).aggregate(FloatFunctions.plus, FloatFunctions.abs);
            float f2 = floatMatrix2D.viewColumn(n2).aggregate(FloatFunctions.plus, FloatFunctions.abs);
            floatMatrix2D.setQuick(n2, n2, Math.max(f, f2) + (float)n2 + 1.0f);
        }
    }

    protected static String get(ObjectArrayList objectArrayList, int n) {
        return (String)objectArrayList.get(n);
    }

    public boolean isDiagonal(FloatMatrix2D floatMatrix2D) {
        float f = this.tolerance();
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || Math.abs(floatMatrix2D.getQuick(n3, n4)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(FloatMatrix2D floatMatrix2D) {
        int n;
        FloatFunctions floatFunctions = FloatFunctions.functions;
        int n2 = n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        while (--n2 >= 0) {
            float f = Math.abs(floatMatrix2D.getQuick(n2, n2));
            if (!((f += f) <= floatMatrix2D.viewColumn(n2).aggregate(FloatFunctions.plus, FloatFunctions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(FloatMatrix2D floatMatrix2D) {
        int n;
        FloatFunctions floatFunctions = FloatFunctions.functions;
        int n2 = n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        while (--n2 >= 0) {
            float f = Math.abs(floatMatrix2D.getQuick(n2, n2));
            if (!((f += f) <= floatMatrix2D.viewRow(n2).aggregate(FloatFunctions.plus, FloatFunctions.abs))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(FloatMatrix2D floatMatrix2D) {
        float f = this.tolerance();
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                float f2 = floatMatrix2D.getQuick(n3, n4);
                if (!(n3 == n4 ? !(Math.abs(1.0f - f2) < f) : !(Math.abs(f2) <= f))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(FloatMatrix2D floatMatrix2D) {
        float f = this.tolerance();
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 + 1 || Math.abs(floatMatrix2D.getQuick(n3, n4)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(FloatMatrix2D floatMatrix2D) {
        int n;
        float f = this.tolerance();
        int n2 = floatMatrix2D.rows();
        int n3 = n = floatMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n3, n2);
            while (--n4 >= 0) {
                if (Math.abs(floatMatrix2D.getQuick(n4, n3)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (floatMatrix2D.getQuick(n3, n4) >= 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(FloatMatrix2D floatMatrix2D) {
        this.checkSquare(floatMatrix2D);
        return this.equals(floatMatrix2D.zMult(floatMatrix2D, null, 1.0f, 0.0f, false, true), FloatFactory2D.dense.identity(floatMatrix2D.rows()));
    }

    public boolean isPositive(FloatMatrix2D floatMatrix2D) {
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (floatMatrix2D.getQuick(n3, n4) > 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular(FloatMatrix2D floatMatrix2D) {
        return !(Math.abs(DenseFloatAlgebra.DEFAULT.det(floatMatrix2D)) >= this.tolerance());
    }

    public boolean isSkewSymmetric(FloatMatrix2D floatMatrix2D) {
        int n;
        this.checkSquare(floatMatrix2D);
        float f = this.tolerance();
        int n2 = n = floatMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n;
            while (--n3 >= 0) {
                if (Math.abs(floatMatrix2D.getQuick(n2, n3) + floatMatrix2D.getQuick(n3, n2)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(FloatMatrix2D floatMatrix2D) {
        return floatMatrix2D.rows() == floatMatrix2D.columns();
    }

    public boolean isStrictlyLowerTriangular(FloatMatrix2D floatMatrix2D) {
        int n;
        float f = this.tolerance();
        int n2 = floatMatrix2D.rows();
        int n3 = n = floatMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = Math.min(n2, n3 + 1);
            while (--n4 >= 0) {
                if (Math.abs(floatMatrix2D.getQuick(n4, n3)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(FloatMatrix2D floatMatrix2D) {
        if (!this.isTriangular(floatMatrix2D)) {
            return false;
        }
        float f = this.tolerance();
        int n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        while (--n >= 0) {
            if (Math.abs(floatMatrix2D.getQuick(n, n)) <= f) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(FloatMatrix2D floatMatrix2D) {
        int n;
        float f = this.tolerance();
        int n2 = floatMatrix2D.rows();
        int n3 = n = floatMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= n3) {
                if (Math.abs(floatMatrix2D.getQuick(n4, n3)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(FloatMatrix2D floatMatrix2D) {
        this.checkSquare(floatMatrix2D);
        return this.equals(floatMatrix2D, floatMatrix2D.viewDice());
    }

    public boolean isTriangular(FloatMatrix2D floatMatrix2D) {
        return this.isLowerTriangular(floatMatrix2D) || this.isUpperTriangular(floatMatrix2D);
    }

    public boolean isTridiagonal(FloatMatrix2D floatMatrix2D) {
        float f = this.tolerance();
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (Math.abs(n3 - n4) <= 1 || Math.abs(floatMatrix2D.getQuick(n3, n4)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(FloatMatrix2D floatMatrix2D) {
        if (!this.isTriangular(floatMatrix2D)) {
            return false;
        }
        float f = this.tolerance();
        int n = Math.min(floatMatrix2D.rows(), floatMatrix2D.columns());
        while (--n >= 0) {
            if (Math.abs(1.0f - floatMatrix2D.getQuick(n, n)) <= f) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(FloatMatrix2D floatMatrix2D) {
        float f = this.tolerance();
        int n = floatMatrix2D.rows();
        int n2 = floatMatrix2D.columns();
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                if (n3 == n4 || n3 == n4 - 1 || Math.abs(floatMatrix2D.getQuick(n3, n4)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(FloatMatrix2D floatMatrix2D) {
        int n;
        float f = this.tolerance();
        int n2 = floatMatrix2D.rows();
        int n3 = n = floatMatrix2D.columns();
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 > n3) {
                if (Math.abs(floatMatrix2D.getQuick(n4, n3)) <= f) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(FloatMatrix2D floatMatrix2D) {
        return this.equals(floatMatrix2D, 0.0f);
    }

    public int lowerBandwidth(FloatMatrix2D floatMatrix2D) {
        int n;
        this.checkSquare(floatMatrix2D);
        float f = this.tolerance();
        int n2 = n = floatMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (Math.abs(floatMatrix2D.getQuick(n4, n3)) <= f) continue;
                return n2;
            }
        }
        return 0;
    }

    public int semiBandwidth(FloatMatrix2D floatMatrix2D) {
        int n;
        this.checkSquare(floatMatrix2D);
        float f = this.tolerance();
        int n2 = n = floatMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (!(Math.abs(floatMatrix2D.getQuick(n4, n3)) <= f)) {
                    return n2 + 1;
                }
                if (Math.abs(floatMatrix2D.getQuick(n3, n4)) <= f) continue;
                return n2 + 1;
            }
        }
        return 1;
    }

    public void setTolerance(float f) {
        if (this == DEFAULT || this == ZERO || this == SEVEN) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(f);
    }

    public float tolerance() {
        return this.tolerance;
    }

    public String toString(FloatMatrix2D floatMatrix2D) {
        int n;
        final ObjectArrayList objectArrayList = new ObjectArrayList();
        final ObjectArrayList objectArrayList2 = new ObjectArrayList();
        String string = "Illegal operation or error: ";
        objectArrayList.add("density");
        try {
            objectArrayList2.add(String.valueOf(this.density(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonal(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByRow");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByRow(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isDiagonallyDominantByColumn");
        try {
            objectArrayList2.add(String.valueOf(this.isDiagonallyDominantByColumn(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isIdentity");
        try {
            objectArrayList2.add(String.valueOf(this.isIdentity(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerBidiagonal(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isLowerTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isNonNegative");
        try {
            objectArrayList2.add(String.valueOf(this.isNonNegative(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isOrthogonal");
        try {
            objectArrayList2.add(String.valueOf(this.isOrthogonal(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isPositive");
        try {
            objectArrayList2.add(String.valueOf(this.isPositive(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSingular");
        try {
            objectArrayList2.add(String.valueOf(this.isSingular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSkewSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSkewSymmetric(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSquare");
        try {
            objectArrayList2.add(String.valueOf(this.isSquare(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyLowerTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyLowerTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isStrictlyUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isStrictlyUpperTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isSymmetric");
        try {
            objectArrayList2.add(String.valueOf(this.isSymmetric(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isTridiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isTridiagonal(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUnitTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUnitTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperBidiagonal");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperBidiagonal(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isUpperTriangular");
        try {
            objectArrayList2.add(String.valueOf(this.isUpperTriangular(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("isZero");
        try {
            objectArrayList2.add(String.valueOf(this.isZero(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("lowerBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.lowerBandwidth(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("semiBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.semiBandwidth(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        objectArrayList.add("upperBandwidth");
        try {
            objectArrayList2.add(String.valueOf(this.upperBandwidth(floatMatrix2D)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            objectArrayList2.add(string + illegalArgumentException.getMessage());
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return FloatProperty.get(objectArrayList, n).compareTo(FloatProperty.get(objectArrayList, n2));
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArrayList.get(n);
                objectArrayList.set(n, objectArrayList.get(n2));
                objectArrayList.set(n2, object);
                object = objectArrayList2.get(n);
                objectArrayList2.set(n, objectArrayList2.get(n2));
                objectArrayList2.set(n2, object);
            }
        };
        GenericSorting.quickSort(0, objectArrayList.size(), intComparator, swapper);
        int n2 = 0;
        for (int i = 0; i < objectArrayList.size(); ++i) {
            n = ((String)objectArrayList.get(i)).length();
            n2 = Math.max(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < objectArrayList.size(); ++n) {
            String string2 = (String)objectArrayList.get(n);
            stringBuffer.append(string2);
            stringBuffer.append(FloatProperty.blanks(n2 - string2.length()));
            stringBuffer.append(" : ");
            stringBuffer.append(objectArrayList2.get(n));
            if (n >= objectArrayList.size() - 1) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public int upperBandwidth(FloatMatrix2D floatMatrix2D) {
        int n;
        this.checkSquare(floatMatrix2D);
        float f = this.tolerance();
        int n2 = n = floatMatrix2D.rows();
        while (--n2 >= 0) {
            int n3 = n - n2;
            while (--n3 >= 0) {
                int n4 = n3 + n2;
                if (Math.abs(floatMatrix2D.getQuick(n3, n4)) <= f) continue;
                return n2;
            }
        }
        return 0;
    }
}

