/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list.tboolean;

import cern.colt.Arrays;
import cern.colt.function.tboolean.BooleanProcedure;
import cern.colt.list.tboolean.AbstractBooleanList;
import cern.jet.math.tdouble.DoubleArithmetic;
import cern.jet.random.tdouble.DoubleUniform;
import cern.jet.random.tdouble.engine.DRand;
import java.util.Date;

public class BooleanArrayList
extends AbstractBooleanList {
    private static final long serialVersionUID = 1L;
    protected boolean[] elements;

    public BooleanArrayList() {
        this(10);
    }

    public BooleanArrayList(boolean[] blArray) {
        this.elements(blArray);
    }

    public BooleanArrayList(int n) {
        this(new boolean[n]);
        this.setSizeRaw(0);
    }

    public void add(boolean bl) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = bl;
    }

    public void beforeInsert(int n, boolean bl) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = bl;
        ++this.size;
    }

    public Object clone() {
        BooleanArrayList booleanArrayList = new BooleanArrayList((boolean[])this.elements.clone());
        booleanArrayList.setSizeRaw(this.size);
        return booleanArrayList;
    }

    public BooleanArrayList copy() {
        return (BooleanArrayList)this.clone();
    }

    public void countSortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        BooleanArrayList.checkRangeFromTo(n, n2, this.size);
        boolean[] blArray = this.elements;
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (!blArray[n4++]) continue;
            ++n3;
        }
        n4 = n2 - n + 1 - n3;
        if (n4 > 0) {
            this.fillFromToWith(n, n + n4 - 1, false);
        }
        if (n3 > 0) {
            this.fillFromToWith(n + n4, n + n4 - 1 + n3, true);
        }
    }

    public boolean[] elements() {
        return this.elements;
    }

    public AbstractBooleanList elements(boolean[] blArray) {
        this.elements = blArray;
        this.size = blArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BooleanArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        BooleanArrayList booleanArrayList = (BooleanArrayList)object;
        if (this.size() != booleanArrayList.size()) {
            return false;
        }
        boolean[] blArray = this.elements();
        boolean[] blArray2 = booleanArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (blArray[n] == blArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(BooleanProcedure booleanProcedure) {
        boolean[] blArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (booleanProcedure.apply(blArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public boolean get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public boolean getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(boolean bl, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        BooleanArrayList.checkRangeFromTo(n, n2, this.size);
        boolean[] blArray = this.elements;
        for (int i = n; i <= n2; ++i) {
            if (bl != blArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(boolean bl, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        BooleanArrayList.checkRangeFromTo(n, n2, this.size);
        boolean[] blArray = this.elements;
        for (int i = n2; i >= n; --i) {
            if (bl != blArray[i]) continue;
            return i;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        this.countSortFromTo(n, n2);
    }

    public AbstractBooleanList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new BooleanArrayList(0);
        }
        BooleanArrayList.checkRangeFromTo(n, n2, this.size);
        boolean[] blArray = new boolean[n2 - n + 1];
        System.arraycopy(this.elements, n, blArray, 0, n2 - n + 1);
        return new BooleanArrayList(blArray);
    }

    public void quickSortFromTo(int n, int n2) {
        this.countSortFromTo(n, n2);
    }

    public boolean removeAll(AbstractBooleanList abstractBooleanList) {
        double d;
        if (!(abstractBooleanList instanceof BooleanArrayList)) {
            return super.removeAll(abstractBooleanList);
        }
        if (abstractBooleanList.size() == 0) {
            return false;
        }
        int n = abstractBooleanList.size() - 1;
        int n2 = 0;
        boolean[] blArray = this.elements;
        int n3 = this.size();
        double d2 = abstractBooleanList.size();
        if ((d2 + (d = (double)n3)) * DoubleArithmetic.log2(d2) < d * d2) {
            BooleanArrayList booleanArrayList = (BooleanArrayList)abstractBooleanList.clone();
            booleanArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (booleanArrayList.binarySearchFromTo(blArray[i], 0, n) >= 0) continue;
                blArray[n2++] = blArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractBooleanList.indexOfFromTo(blArray[i], 0, n) >= 0) continue;
                blArray[n2++] = blArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractBooleanList abstractBooleanList, int n3) {
        if (!(abstractBooleanList instanceof BooleanArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractBooleanList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            BooleanArrayList.checkRangeFromTo(n, n2, this.size());
            BooleanArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractBooleanList.size());
            System.arraycopy(((BooleanArrayList)abstractBooleanList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractBooleanList abstractBooleanList) {
        double d;
        if (!(abstractBooleanList instanceof BooleanArrayList)) {
            return super.retainAll(abstractBooleanList);
        }
        int n = abstractBooleanList.size() - 1;
        int n2 = 0;
        boolean[] blArray = this.elements;
        int n3 = this.size();
        double d2 = abstractBooleanList.size();
        if ((d2 + (d = (double)n3)) * DoubleArithmetic.log2(d2) < d * d2) {
            BooleanArrayList booleanArrayList = (BooleanArrayList)abstractBooleanList.clone();
            booleanArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (booleanArrayList.binarySearchFromTo(blArray[i], 0, n) < 0) continue;
                blArray[n2++] = blArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractBooleanList.indexOfFromTo(blArray[i], 0, n) < 0) continue;
                blArray[n2++] = blArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        boolean[] blArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            boolean bl = blArray[n3];
            blArray[n3++] = blArray[n2];
            blArray[n2--] = bl;
        }
    }

    public void set(int n, boolean bl) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = bl;
    }

    public void setQuick(int n, boolean bl) {
        this.elements[n] = bl;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        BooleanArrayList.checkRangeFromTo(n, n2, this.size);
        DoubleUniform doubleUniform = new DoubleUniform(new DRand(new Date()));
        boolean[] blArray = this.elements;
        for (int i = n; i < n2; ++i) {
            int n3 = doubleUniform.nextIntFromTo(i, n2);
            boolean bl = blArray[n3];
            blArray[n3] = blArray[i];
            blArray[i] = bl;
        }
    }

    public void sortFromTo(int n, int n2) {
        this.countSortFromTo(n, n2);
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

