% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/produce_other_report.R
\name{produce_other_report}
\alias{produce_other_report}
\title{Produce an upload-compatible txt file from pre-aggregated files}
\usage{
produce_other_report(..., survey = "MySurvey", part = "AllParts")
}
\arguments{
\item{...}{dataframes (one for each survey part, in order)}

\item{survey}{string with the survey name you'd like in your filename}

\item{part}{string with the part name (subname) you'd like your file name}
}
\value{
txt file on your computer with the title
  \emph{[survey]_[part]_[today's date].txt}
}
\description{
Use this function to create a key-value pair uploadable file
  from your own prepared dataframes, instead of using a different (provided)
  \code{produce} function. Your dataframes must be prepped to match final
  submission requirements as laid out by IPEDS (or whatever survey you will
  use this for. Use this function for one survey at a time, and add a
  separate dataframe for each part to the \code{...} argument. See vignette
  for more details.
}
\note{
You must name the arguments for \code{survey} and \code{part} if using
  non-default value. If the arguments are unnamed, the function will assume
  their values are additional dataframes.
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
#With built-in R data
produce_other_report(mtcars[1:5,], iris[1:5,], ToothGrowth[1:5,], survey = 'FakeSurvey')
\dontshow{
setwd(.old_wd)
}
\donttest{
#Will not execute properly (argument unnamed)
#produce_other_report(mtcars[1:5,], iris[1:5,], ToothGrowth[1:5,], 'FakeSurvey')
}
}
