//#include <stdio.h>

#ifndef  USE_FC_LEN_T
# define USE_FC_LEN_T
#endif
#include <Rconfig.h>
#include <R_ext/BLAS.h>
#ifndef FCONE
# define FCONE
#endif


#include <R.h>
#include <Rinternals.h>
#include <Rmath.h>
#include <R_ext/Lapack.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdint.h>
#include <stdbool.h>
#include <R_ext/Applic.h>
#include <R_ext/Complex.h>
#include <R_ext/Print.h>
#include <R_ext/Linpack.h>
#include <R_ext/Applic.h>
#include <math.h>
#include <R_ext/Memory.h>
#include <float.h>




#define LOW -1.0e15
#define MAXERR 1e-6
#define EPS DBL_EPSILON
#define DEPSILON 10e-16
/* for bivariate t distribution */
#define EPS1 1.0e-10
#define EPS2 1.0e-10
#define Inf R_PosInf
#define ETHRESH 1.0e-12
#define MACHEP   1.11022302462515654042E-16   /* 2**-53 */
#define MAXNUM   1.79769313486231570815E308    /* 2**1024*(1-MACHEP) */
#define MAX_ITERATIONS 10000
#define NPY_NAN R_NaN
#define NPY_PI M_PI
#define MAXLGM 2.556348e305
#define LS2PI  0.91893853320467274178
#define LOGPI  1.14472988584940017414





//************************************** ST igam.c*****************************************

#ifdef MAXITER
#undef MAXITER
#endif
#define MAXITER 2000
#define IGAM 1
#define IGAMC 0
#define SMALL 20
#define LARGE 200
#define SMALLRATIO 0.3
#define LARGERATIO 4.5
#define NPY_INFINITY R_PosInf
#define NPY_PI_4 .78539816339744830962
#define SQ2OPI .79788456080286535588
#define MAXLGM 2.556348e305
#define MAXLOG 7.08396418532264106224E2    /* log 2**1022 */
#define NPY_SQRT1_2   0.707106781186547524400844362104849039  /* 1/sqrt(2) */
#define NPY_SQRT2     1.414213562373095048801688724209698079  /* sqrt(2) */
#define NPY_EULER     0.577215664901532860606512090082402431  /* Euler constant */




/* This file was automatically generated by _precomp/gammainc.py.
 * Do not edit it manually!
 */

#ifndef IGAM_H
#define IGAM_H

#define KIC 25
#define NIC 25

static const double d[KIC][NIC] =
{{-3.3333333333333333e-1, 8.3333333333333333e-2, -1.4814814814814815e-2, 1.1574074074074074e-3, 3.527336860670194e-4, -1.7875514403292181e-4, 3.9192631785224378e-5, -2.1854485106799922e-6, -1.85406221071516e-6, 8.296711340953086e-7, -1.7665952736826079e-7, 6.7078535434014986e-9, 1.0261809784240308e-8, -4.3820360184533532e-9, 9.1476995822367902e-10, -2.551419399494625e-11, -5.8307721325504251e-11, 2.4361948020667416e-11, -5.0276692801141756e-12, 1.1004392031956135e-13, 3.3717632624009854e-13, -1.3923887224181621e-13, 2.8534893807047443e-14, -5.1391118342425726e-16, -1.9752288294349443e-15},
    {-1.8518518518518519e-3, -3.4722222222222222e-3, 2.6455026455026455e-3, -9.9022633744855967e-4, 2.0576131687242798e-4, -4.0187757201646091e-7, -1.8098550334489978e-5, 7.6491609160811101e-6, -1.6120900894563446e-6, 4.6471278028074343e-9, 1.378633446915721e-7, -5.752545603517705e-8, 1.1951628599778147e-8, -1.7543241719747648e-11, -1.0091543710600413e-9, 4.1627929918425826e-10, -8.5639070264929806e-11, 6.0672151016047586e-14, 7.1624989648114854e-12, -2.9331866437714371e-12, 5.9966963656836887e-13, -2.1671786527323314e-16, -4.9783399723692616e-14, 2.0291628823713425e-14, -4.13125571381061e-15},
    {4.1335978835978836e-3, -2.6813271604938272e-3, 7.7160493827160494e-4, 2.0093878600823045e-6, -1.0736653226365161e-4, 5.2923448829120125e-5, -1.2760635188618728e-5, 3.4235787340961381e-8, 1.3721957309062933e-6, -6.298992138380055e-7, 1.4280614206064242e-7, -2.0477098421990866e-10, -1.4092529910867521e-8, 6.228974084922022e-9, -1.3670488396617113e-9, 9.4283561590146782e-13, 1.2872252400089318e-10, -5.5645956134363321e-11, 1.1975935546366981e-11, -4.1689782251838635e-15, -1.0940640427884594e-12, 4.6622399463901357e-13, -9.905105763906906e-14, 1.8931876768373515e-17, 8.8592218725911273e-15},
    {6.4943415637860082e-4, 2.2947209362139918e-4, -4.6918949439525571e-4, 2.6772063206283885e-4, -7.5618016718839764e-5, -2.3965051138672967e-7, 1.1082654115347302e-5, -5.6749528269915966e-6, 1.4230900732435884e-6, -2.7861080291528142e-11, -1.6958404091930277e-7, 8.0994649053880824e-8, -1.9111168485973654e-8, 2.3928620439808118e-12, 2.0620131815488798e-9, -9.4604966618551322e-10, 2.1541049775774908e-10, -1.388823336813903e-14, -2.1894761681963939e-11, 9.7909989511716851e-12, -2.1782191880180962e-12, 6.2088195734079014e-17, 2.126978363279737e-13, -9.3446887915174333e-14, 2.0453671226782849e-14},
    {-8.618882909167117e-4, 7.8403922172006663e-4, -2.9907248030319018e-4, -1.4638452578843418e-6, 6.6414982154651222e-5, -3.9683650471794347e-5, 1.1375726970678419e-5, 2.5074972262375328e-10, -1.6954149536558306e-6, 8.9075075322053097e-7, -2.2929348340008049e-7, 2.956794137544049e-11, 2.8865829742708784e-8, -1.4189739437803219e-8, 3.4463580499464897e-9, -2.3024517174528067e-13, -3.9409233028046405e-10, 1.8602338968504502e-10, -4.356323005056618e-11, 1.2786001016296231e-15, 4.6792750266579195e-12, -2.1492464706134829e-12, 4.9088156148096522e-13, -6.3385914848915603e-18, -5.0453320690800944e-14},
    {-3.3679855336635815e-4, -6.9728137583658578e-5, 2.7727532449593921e-4, -1.9932570516188848e-4, 6.7977804779372078e-5, 1.419062920643967e-7, -1.3594048189768693e-5, 8.0184702563342015e-6, -2.2914811765080952e-6, -3.252473551298454e-10, 3.4652846491085265e-7, -1.8447187191171343e-7, 4.8240967037894181e-8, -1.7989466721743515e-14, -6.3061945000135234e-9, 3.1624176287745679e-9, -7.8409242536974293e-10, 5.1926791652540407e-15, 9.3589442423067836e-11, -4.5134262161632782e-11, 1.0799129993116827e-11, -3.661886712685252e-17, -1.210902069055155e-12, 5.6807435849905643e-13, -1.3249659916340829e-13},
    {5.3130793646399222e-4, -5.9216643735369388e-4, 2.7087820967180448e-4, 7.9023532326603279e-7, -8.1539693675619688e-5, 5.6116827531062497e-5, -1.8329116582843376e-5, -3.0796134506033048e-9, 3.4651553688036091e-6, -2.0291327396058604e-6, 5.7887928631490037e-7, 2.338630673826657e-13, -8.8286007463304835e-8, 4.7435958880408128e-8, -1.2545415020710382e-8, 8.6496488580102925e-14, 1.6846058979264063e-9, -8.5754928235775947e-10, 2.1598224929232125e-10, -7.6132305204761539e-16, -2.6639822008536144e-11, 1.3065700536611057e-11, -3.1799163902367977e-12, 4.7109761213674315e-18, 3.6902800842763467e-13},
    {3.4436760689237767e-4, 5.1717909082605922e-5, -3.3493161081142236e-4, 2.812695154763237e-4, -1.0976582244684731e-4, -1.2741009095484485e-7, 2.7744451511563644e-5, -1.8263488805711333e-5, 5.7876949497350524e-6, 4.9387589339362704e-10, -1.0595367014026043e-6, 6.1667143761104075e-7, -1.7562973359060462e-7, -1.2974473287015439e-12, 2.695423606288966e-8, -1.4578352908731271e-8, 3.887645959386175e-9, -3.8810022510194121e-17, -5.3279941738772867e-10, 2.7437977643314845e-10, -6.9957960920705679e-11, 2.5899863874868481e-17, 8.8566890996696381e-12, -4.403168815871311e-12, 1.0865561947091654e-12},
    {-6.5262391859530942e-4, 8.3949872067208728e-4, -4.3829709854172101e-4, -6.969091458420552e-7, 1.6644846642067548e-4, -1.2783517679769219e-4, 4.6299532636913043e-5, 4.5579098679227077e-9, -1.0595271125805195e-5, 6.7833429048651666e-6, -2.1075476666258804e-6, -1.7213731432817145e-11, 3.7735877416110979e-7, -2.1867506700122867e-7, 6.2202288040189269e-8, 6.5977038267330006e-16, -9.5903864974256858e-9, 5.2132144922808078e-9, -1.3991589583935709e-9, 5.382058999060575e-16, 1.9484714275467745e-10, -1.0127287556389682e-10, 2.6077347197254926e-11, -5.0904186999932993e-18, -3.3721464474854592e-12},
    {-5.9676129019274625e-4, -7.2048954160200106e-5, 6.7823088376673284e-4, -6.4014752602627585e-4, 2.7750107634328704e-4, 1.8197008380465151e-7, -8.4795071170685032e-5, 6.105192082501531e-5, -2.1073920183404862e-5, -8.8585890141255994e-10, 4.5284535953805377e-6, -2.8427815022504408e-6, 8.7082341778646412e-7, 3.6886101871706965e-12, -1.5344695190702061e-7, 8.862466778790695e-8, -2.5184812301826817e-8, -1.0225912098215092e-14, 3.8969470758154777e-9, -2.1267304792235635e-9, 5.7370135528051385e-10, -1.887749850169741e-19, -8.0931538694657866e-11, 4.2382723283449199e-11, -1.1002224534207726e-11},
    {1.3324454494800656e-3, -1.9144384985654775e-3, 1.1089369134596637e-3, 9.932404122642299e-7, -5.0874501293093199e-4, 4.2735056665392884e-4, -1.6858853767910799e-4, -8.1301893922784998e-9, 4.5284402370562147e-5, -3.127053674781734e-5, 1.044986828530338e-5, 4.8435226265680926e-11, -2.1482565873456258e-6, 1.329369701097492e-6, -4.0295693092101029e-7, -1.7567877666323291e-13, 7.0145043163668257e-8, -4.040787734999483e-8, 1.1474026743371963e-8, 3.9642746853563325e-18, -1.7804938269892714e-9, 9.7480262548731646e-10, -2.6405338676507616e-10, 5.794875163403742e-18, 3.7647749553543836e-11},
    {1.579727660730835e-3, 1.6251626278391582e-4, -2.0633421035543276e-3, 2.1389686185689098e-3, -1.0108559391263003e-3, -3.9912705529919201e-7, 3.6235025084764691e-4, -2.8143901463712154e-4, 1.0449513336495887e-4, 2.1211418491830297e-9, -2.5779417251947842e-5, 1.7281818956040463e-5, -5.6413773872904282e-6, -1.1024320105776174e-11, 1.1223224418895175e-6, -6.8693396379526735e-7, 2.0653236975414887e-7, 4.6714772409838506e-14, -3.5609886164949055e-8, 2.0470855345905963e-8, -5.8091738633283358e-9, -1.332821287582869e-16, 9.0354604391335133e-10, -4.9598782517330834e-10, 1.3481607129399749e-10},
    {-4.0725121195140166e-3, 6.4033628338080698e-3, -4.0410161081676618e-3, -2.183732802866233e-6, 2.1740441801254639e-3, -1.9700440518418892e-3, 8.3595469747962458e-4, 1.9445447567109655e-8, -2.5779387120421696e-4, 1.9009987368139304e-4, -6.7696499937438965e-5, -1.4440629666426572e-10, 1.5712512518742269e-5, -1.0304008744776893e-5, 3.304517767401387e-6, 7.9829760242325709e-13, -6.4097794149313004e-7, 3.8894624761300056e-7, -1.1618347644948869e-7, -2.816808630596451e-15, 1.9878012911297093e-8, -1.1407719956357511e-8, 3.2355857064185555e-9, 4.1759468293455945e-20, -5.0423112718105824e-10},
    {-5.9475779383993003e-3, -5.4016476789260452e-4, 8.7910413550767898e-3, -9.8576315587856125e-3, 5.0134695031021538e-3, 1.2807521786221875e-6, -2.0626019342754683e-3, 1.7109128573523058e-3, -6.7695312714133799e-4, -6.9011545676562133e-9, 1.8855128143995902e-4, -1.3395215663491969e-4, 4.6263183033528039e-5, 4.0034230613321351e-11, -1.0255652921494033e-5, 6.612086372797651e-6, -2.0913022027253008e-6, -2.0951775649603837e-13, 3.9756029041993247e-7, -2.3956211978815887e-7, 7.1182883382145864e-8, 8.925574873053455e-16, -1.2101547235064676e-8, 6.9350618248334386e-9, -1.9661464453856102e-9},
    {1.7402027787522711e-2, -2.9527880945699121e-2, 2.0045875571402799e-2, 7.0289515966903407e-6, -1.2375421071343148e-2, 1.1976293444235254e-2, -5.4156038466518525e-3, -6.3290893396418616e-8, 1.8855118129005065e-3, -1.473473274825001e-3, 5.5515810097708387e-4, 5.2406834412550662e-10, -1.4357913535784836e-4, 9.9181293224943297e-5, -3.3460834749478311e-5, -3.5755837291098993e-12, 7.1560851960630076e-6, -4.5516802628155526e-6, 1.4236576649271475e-6, 1.8803149082089664e-14, -2.6623403898929211e-7, 1.5950642189595716e-7, -4.7187514673841102e-8, -6.5107872958755177e-17, 7.9795091026746235e-9},
    {3.0249124160905891e-2, 2.4817436002649977e-3, -4.9939134373457022e-2, 5.9915643009307869e-2, -3.2483207601623391e-2, -5.7212968652103441e-6, 1.5085251778569354e-2, -1.3261324005088445e-2, 5.5515262632426148e-3, 3.0263182257030016e-8, -1.7229548406756723e-3, 1.2893570099929637e-3, -4.6845138348319876e-4, -1.830259937893045e-10, 1.1449739014822654e-4, -7.7378565221244477e-5, 2.5625836246985201e-5, 1.0766165333192814e-12, -5.3246809282422621e-6, 3.349634863064464e-6, -1.0381253128684018e-6, -5.608909920621128e-15, 1.9150821930676591e-7, -1.1418365800203486e-7, 3.3654425209171788e-8},
    {-9.9051020880159045e-2, 1.7954011706123486e-1, -1.2989606383463778e-1, -3.1478872752284357e-5, 9.0510635276848131e-2, -9.2828824411184397e-2, 4.4412112839877808e-2, 2.7779236316835888e-7, -1.7229543805449697e-2, 1.4182925050891573e-2, -5.6214161633747336e-3, -2.39598509186381e-9, 1.6029634366079908e-3, -1.1606784674435773e-3, 4.1001337768153873e-4, 1.8365800754090661e-11, -9.5844256563655903e-5, 6.3643062337764708e-5, -2.076250624489065e-5, -1.1806020912804483e-13, 4.2131808239120649e-6, -2.6262241337012467e-6, 8.0770620494930662e-7, 6.0125912123632725e-16, -1.4729737374018841e-7},
    {-1.9994542198219728e-1, -1.5056113040026424e-2, 3.6470239469348489e-1, -4.6435192311733545e-1, 2.6640934719197893e-1, 3.4038266027147191e-5, -1.3784338709329624e-1, 1.276467178337056e-1, -5.6213828755200985e-2, -1.753150885483011e-7, 1.9235592956768113e-2, -1.5088821281095315e-2, 5.7401854451350123e-3, 1.0622382710310225e-9, -1.5335082692563998e-3, 1.0819320643228214e-3, -3.7372510193945659e-4, -6.6170909729031985e-12, 8.4263617380909628e-5, -5.5150706827483479e-5, 1.7769536448348069e-5, 3.8827923210205533e-14, -3.53513697488768e-6, 2.1865832130045269e-6, -6.6812849447625594e-7},
    {7.2438608504029431e-1, -1.3918010932653375, 1.0654143352413968, 1.876173868950258e-4, -8.2705501176152696e-1, 8.9352433347828414e-1, -4.4971003995291339e-1, -1.6107401567546652e-6, 1.9235590165271091e-1, -1.6597702160042609e-1, 6.8882222681814333e-2, 1.3910091724608687e-8, -2.146911561508663e-2, 1.6228980898865892e-2, -5.9796016172584256e-3, -1.1287469112826745e-10, 1.5167451119784857e-3, -1.0478634293553899e-3, 3.5539072889126421e-4, 8.1704322111801517e-13, -7.7773013442452395e-5, 5.0291413897007722e-5, -1.6035083867000518e-5, 1.2469354315487605e-14, 3.1369106244517615e-6},
    {1.6668949727276811, 1.165462765994632e-1, -3.3288393225018906, 4.4692325482864037, -2.6977693045875807, -2.600667859891061e-4, 1.5389017615694539, -1.4937962361134612, 6.8881964633233148e-1, 1.3077482004552385e-6, -2.5762963325596288e-1, 2.1097676102125449e-1, -8.3714408359219882e-2, -7.7920428881354753e-9, 2.4267923064833599e-2, -1.7813678334552311e-2, 6.3970330388900056e-3, 4.9430807090480523e-11, -1.5554602758465635e-3, 1.0561196919903214e-3, -3.5277184460472902e-4, 9.3002334645022459e-14, 7.5285855026557172e-5, -4.8186515569156351e-5, 1.5227271505597605e-5},
    {-6.6188298861372935, 1.3397985455142589e+1, -1.0789350606845146e+1, -1.4352254537875018e-3, 9.2333694596189809, -1.0456552819547769e+1, 5.5105526029033471, 1.2024439690716742e-5, -2.5762961164755816, 2.3207442745387179, -1.0045728797216284, -1.0207833290021914e-7, 3.3975092171169466e-1, -2.6720517450757468e-1, 1.0235252851562706e-1, 8.4329730484871625e-10, -2.7998284958442595e-2, 2.0066274144976813e-2, -7.0554368915086242e-3, 1.9402238183698188e-12, 1.6562888105449611e-3, -1.1082898580743683e-3, 3.654545161310169e-4, -5.1290032026971794e-11, -7.6340103696869031e-5},
    {-1.7112706061976095e+1, -1.1208044642899116, 3.7131966511885444e+1, -5.2298271025348962e+1, 3.3058589696624618e+1, 2.4791298976200222e-3, -2.061089403411526e+1, 2.088672775145582e+1, -1.0045703956517752e+1, -1.2238783449063012e-5, 4.0770134274221141, -3.473667358470195, 1.4329352617312006, 7.1359914411879712e-8, -4.4797257159115612e-1, 3.4112666080644461e-1, -1.2699786326594923e-1, -2.8953677269081528e-10, 3.3125776278259863e-2, -2.3274087021036101e-2, 8.0399993503648882e-3, -1.177805216235265e-9, -1.8321624891071668e-3, 1.2108282933588665e-3, -3.9479941246822517e-4},
    {7.389033153567425e+1, -1.5680141270402273e+2, 1.322177542759164e+2, 1.3692876877324546e-2, -1.2366496885920151e+2, 1.4620689391062729e+2, -8.0365587724865346e+1, -1.1259851148881298e-4, 4.0770132196179938e+1, -3.8210340013273034e+1, 1.719522294277362e+1, 9.3519707955168356e-7, -6.2716159907747034, 5.1168999071852637, -2.0319658112299095, -4.9507215582761543e-9, 5.9626397294332597e-1, -4.4220765337238094e-1, 1.6079998700166273e-1, -2.4733786203223402e-8, -4.0307574759979762e-2, 2.7849050747097869e-2, -9.4751858992054221e-3, 6.419922235909132e-6, 2.1250180774699461e-3},
    {2.1216837098382522e+2, 1.3107863022633868e+1, -4.9698285932871748e+2, 7.3121595266969204e+2, -4.8213821720890847e+2, -2.8817248692894889e-2, 3.2616720302947102e+2, -3.4389340280087117e+2, 1.7195193870816232e+2, 1.4038077378096158e-4, -7.52594195897599e+1, 6.651969984520934e+1, -2.8447519748152462e+1, -7.613702615875391e-7, 9.5402237105304373, -7.5175301113311376, 2.8943997568871961, -4.6612194999538201e-7, -8.0615149598794088e-1, 5.8483006570631029e-1, -2.0845408972964956e-1, 1.4765818959305817e-4, 5.1000433863753019e-2, -3.3066252141883665e-2, 1.5109265210467774e-2},
    {-9.8959643098322368e+2, 2.1925555360905233e+3, -1.9283586782723356e+3, -1.5925738122215253e-1, 1.9569985945919857e+3, -2.4072514765081556e+3, 1.3756149959336496e+3, 1.2920735237496668e-3, -7.525941715948055e+2, 7.3171668742208716e+2, -3.4137023466220065e+2, -9.9857390260608043e-6, 1.3356313181291573e+2, -1.1276295161252794e+2, 4.6310396098204458e+1, -7.9237387133614756e-6, -1.4510726927018646e+1, 1.1111771248100563e+1, -4.1690817945270892, 3.1008219800117808e-3, 1.1220095449981468, -7.6052379926149916e-1, 3.6262236505085254e-1, 2.216867741940747e-1, 4.8683443692930507e-1}};

#endif



/*  (C) Copyright John Maddock 2006.
 *  Use, modification and distribution are subject to the
 *  Boost Software License, Version 1.0. (See accompanying file
 *  LICENSE_1_0.txt or copy at https://www.boost.org/LICENSE_1_0.txt)
 */

/* Both lanczos.h and lanczos.c were formed from Boost's lanczos.hpp
 *
 * Scipy changes:
 * - 06-22-2016: Removed all code not related to double precision and
 *   ported to c for use in Cephes. Note that the order of the
 *   coefficients is reversed to match the behavior of polevl.
 */

/*
 * Optimal values for G for each N are taken from
 * https://web.viu.ca/pughg/phdThesis/phdThesis.pdf,
 * as are the theoretical error bounds.
 *
 * Constants calculated using the method described by Godfrey
 * https://my.fit.edu/~gabdo/gamma.txt and elaborated by Toth at
 * https://www.rskey.org/gamma.htm using NTL::RR at 1000 bit precision.
 */

/*
 * Lanczos Coefficients for N=13 G=6.024680040776729583740234375
 * Max experimental error (with arbitrary precision arithmetic) 1.196214e-17
 * Generated with compiler: Microsoft Visual C++ version 8.0 on Win32 at Mar 23 2006
 *
 * Use for double precision.
 */

#ifndef LANCZOS_H
#define LANCZOS_H


static const double lanczos_num[13] = {
    2.506628274631000270164908177133837338626,
    210.8242777515793458725097339207133627117,
    8071.672002365816210638002902272250613822,
    186056.2653952234950402949897160456992822,
    2876370.628935372441225409051620849613599,
    31426415.58540019438061423162831820536287,
    248874557.8620541565114603864132294232163,
    1439720407.311721673663223072794912393972,
    6039542586.35202800506429164430729792107,
    17921034426.03720969991975575445893111267,
    35711959237.35566804944018545154716670596,
    42919803642.64909876895789904700198885093,
    23531376880.41075968857200767445163675473
};

static const double lanczos_denom[13] = {
    1,
    66,
    1925,
    32670,
    357423,
    2637558,
    13339535,
    45995730,
    105258076,
    150917976,
    120543840,
    39916800,
    0
};

static const double lanczos_sum_expg_scaled_num[13] = {
    0.006061842346248906525783753964555936883222,
    0.5098416655656676188125178644804694509993,
    19.51992788247617482847860966235652136208,
    449.9445569063168119446858607650988409623,
    6955.999602515376140356310115515198987526,
    75999.29304014542649875303443598909137092,
    601859.6171681098786670226533699352302507,
    3481712.15498064590882071018964774556468,
    14605578.08768506808414169982791359218571,
    43338889.32467613834773723740590533316085,
    86363131.28813859145546927288977868422342,
    103794043.1163445451906271053616070238554,
    56906521.91347156388090791033559122686859
};

static const double lanczos_sum_expg_scaled_denom[13] = {
    1,
    66,
    1925,
    32670,
    357423,
    2637558,
    13339535,
    45995730,
    105258076,
    150917976,
    120543840,
    39916800,
    0
};

static const double lanczos_sum_near_1_d[12] = {
    0.3394643171893132535170101292240837927725e-9,
    -0.2499505151487868335680273909354071938387e-8,
    0.8690926181038057039526127422002498960172e-8,
    -0.1933117898880828348692541394841204288047e-7,
    0.3075580174791348492737947340039992829546e-7,
    -0.2752907702903126466004207345038327818713e-7,
    -0.1515973019871092388943437623825208095123e-5,
    0.004785200610085071473880915854204301886437,
    -0.1993758927614728757314233026257810172008,
    1.483082862367253753040442933770164111678,
    -3.327150580651624233553677113928873034916,
    2.208709979316623790862569924861841433016
};

static const double lanczos_sum_near_2_d[12] = {
    0.1009141566987569892221439918230042368112e-8,
    -0.7430396708998719707642735577238449585822e-8,
    0.2583592566524439230844378948704262291927e-7,
    -0.5746670642147041587497159649318454348117e-7,
    0.9142922068165324132060550591210267992072e-7,
    -0.8183698410724358930823737982119474130069e-7,
    -0.4506604409707170077136555010018549819192e-5,
    0.01422519127192419234315002746252160965831,
    -0.5926941084905061794445733628891024027949,
    4.408830289125943377923077727900630927902,
    -9.8907772644920670589288081640128194231,
    6.565936202082889535528455955485877361223
};

static const double lanczos_g = 6.024680040776729583740234375;

#endif


static const double big = 4.503599627370496e15;
static const double biginv = 2.22044604925031308085e-16;

double igamc_continued_fraction(double, double);
double igam_series(double, double);
double igamc_series(double, double);
double asymptotic_series(double, double, int);
void igam_call(double *a,double *x,double *res);


double igam(double a, double x);
double igamc(double a, double x);

void  reghyperg_call(int *a,int *b,double *x,double *res);
void hyperg_1F2_e_call( double *a,  double *b,double *c,  double *x, double *val);


void Maxima_Minima_time(double *res,double *coordt,int *nsize);
double lanczos_sum_expg_scaled(double x);


double ratevl(double x, const double num[], int M,
              const double denom[], int NN);



static const double LP[] = {
    4.5270000862445199635215E-5,
    4.9854102823193375972212E-1,
    6.5787325942061044846969E0,
    2.9911919328553073277375E1,
    6.0949667980987787057556E1,
    5.7112963590585538103336E1,
    2.0039553499201281259648E1,
};

static const double LQ[] = {
    /* 1.0000000000000000000000E0, */
    1.5062909083469192043167E1,
    8.3047565967967209469434E1,
    2.2176239823732856465394E2,
    3.0909872225312059774938E2,
    2.1642788614495947685003E2,
    6.0118660497603843919306E1,
};



static const double coscof[7] = {
    4.7377507964246204691685E-14,
    -1.1470284843425359765671E-11,
    2.0876754287081521758361E-9,
    -2.7557319214999787979814E-7,
    2.4801587301570552304991E-5,
    -1.3888888888888872993737E-3,
    4.1666666666666666609054E-2,
};



/* expm1(x) = exp(x) - 1  */

/*  e^x =  1 + 2x P(x^2)/( Q(x^2) - P(x^2) )
 * -0.5 <= x <= 0.5
 */



static const double EP[3] = {
    1.2617719307481059087798E-4,
    3.0299440770744196129956E-2,
    9.9999999999999999991025E-1,
};

static const double EQ[4] = {
    3.0019850513866445504159E-6,
    2.5244834034968410419224E-3,
    2.2726554820815502876593E-1,
    2.0000000000000000000897E0,
};



static const double AA[] = {
    12.0,
    -720.0,
    30240.0,
    -1209600.0,
    47900160.0,
    -1.8924375803183791606e9,
    7.47242496e10,
    -2.950130727918164224e12,
    1.1646782814350067249e14,
    -4.5979787224074726105e15,
    1.8152105401943546773e17,
    -7.1661652561756670113e18
};



//************************************* END igam.c*****************************************









//---------START GLOBAL VARIABLES-----------

extern double **dista;// 2x2 matrix of distance weight (for c)and commpact suppots (tap)
extern int *first;//vector of index in the bivariate case
extern int *first_1;//vector of index in the bivariate case
extern int *second;//vector of index in the bivariate case
extern int *second_1;//vector of index in the bivariate case
extern int *isbiv;//is bivariate?
extern int *ismem;//is with memoty allocation
extern int *isst;//is a spatio-temporal random field?
extern int *istap;//is tapering?
extern double *lags;// vector of spatial distances for tapering
extern double *lags_1;// vector of spatial distances for tapering
extern double *lagt;// vector of temporal distance for tapering
//double **mlags;// vector of spatial distances
//double **mlagt;// vector of temporal distances
extern double *maxdist;// the threshould of the spatial distances
extern double *maxtime;// the threshould of the temporal distances below which the pairs are considered
//double *maximdista;// the maximum spatial distance
//double *maximtime;// the maximum temporal distance
//double *minimdista; // the minimum spatial distance
//double *minimtime;// the minimum temporal distance
extern int *ncoord;// number of total spatial coordinates
extern int *ncoordx;// number of the first spatial coordinates
extern int *ncoordy;// number of the second spatial coordinates
extern int *ncoordz;// number of the second spatial coordinates
extern int *npairs;// effective number of pairs
//int *nrep;// number of iid replicates of the random field
extern int *ntime;// number of times
extern double *REARTH; // radius of the sphere
extern double *tapsep; // parameter separability for space time quasi taper
extern double *tlags; //double *mtlags;double *mtlagt;
extern double *tlagt;
extern int *tfirst;
extern int *tsecond;
extern int *type;  //  type of distance
extern int *cdyn; // dynamic coords indicator
//char *fkernel; // path to kernel binary
//int *totpairs;// total number of pairs
//---------END GLOBAL VARIABLES-------------
//void indx(double *ind, int *n);



// fortran declaration for bivariate normal cdf:
extern double F77_NAME(chfm)(double *xr,double *xi,double *ar, double *ai,
  double *br, double *bi,double *r, double *ri,int *len, int *lnchf,int *ip);

//extern double F77_NAME(bvnmvn)(double *lower, double *upper, int *infin, double *correl);

extern void mult_pmnorm( int *nvar , double *lower , double *upper , int *infin , double *corr , int *maxpts , double *abseps ,
     double *releps , double *esterror , double *result , int *fail );

//extern void F77_NAME(sadmvn)( int* , double* , double*, int* , double* , int* , double* , double* , double* , double * , int*) ;

//extern double F77_NAME(mvndst)(int *N,double *lower, double *upper, int *infin, double *correl);


extern void F77_NAME(chgu)(double *,double *,double *,double *, int *, int *);

double hypU_wrap(double a, double b, double x);

// Internal function declaration:
// 1)
/*----------------------------------------------------------------
File name: CorrelationFunction.c
Description: procedures for computation of correlation functions
Start
 ---------------------------------------------------------------*/
double Hyp_conf_laplace_approx(double a, double b, double z);
double asym_aprox_1F1(double a, double b, double z);
int fmax_int(int u,int v);
int fmin_int(int u,int v);
//double hypergeo(double aux, double *param);

double bi_matern_bounds(double scale11,double scale22,double scale12,double nu11,double nu22,double nu12,double t,int c);
double cdf_norm(double lim1,double lim2,double a11,double a12);

double owens_t(double h, double a);
double psn(double x,  double omega, double alpha, double tau);
double dsn(double x, double omega, double alpha, double tau);
double qsn(double p, double omega, double alpha, double tau, double tol);

double one_log_SkewLaplace(double x, double m, double sill, double skew);
double one_log_wrapped(double alfa,double u,double mi,double sill);
double one_log_T(double z,double m, double sill, double df);
double one_log_tukeyh(double z,double m, double sill, double tail);
double one_log_tukeyhh(double z,double m, double sill, double h1,double h2);
double one_log_SkewGauss(double z,double m, double vari, double skew);
double one_log_sas(double z,double m, double skew, double tail,  double vari);
double one_log_kumma2(double z,double m, double shape1,double shape2,double min,double  max);
double one_log_kumma(double z,double m, double shape1,double shape2,double min,double  max);
double one_log_beta(double z, double shape1,double shape2,double min,double  max);
double one_log_loggaussian(double z,double m, double sill);
double one_log_dpoisgamma(int z,double lambda, double a);
double one_log_weibull(double z,double m, double shape);
double one_log_gamma(double z,double m, double shape);
double one_log_two_pieceTukey(double z,double m, double sill,double tail, double eta);
double one_log_two_pieceT(double z,double m, double sill, double df, double eta);
double one_log_two_pieceGauss(double z,double m, double sill, double eta);
double one_log_gammagem(double z,double shape,double n);
double one_log_bomidal(double z,double m, double sill,double nu,double delta, double eta);
double one_log_BinomnegZIP(int z,double n, double mu, double mup);
double one_log_PoisZIP(int z,double lambda, double mup);
double one_log_PoisgammaZIP(int z,double lambda, double mup,double shape);
double one_log_loglogistic(double z,double m, double shape);
double one_log_logistic(double z,double m, double sill);
double one_log_negbinom_marg(int u,int N, double p);
double biv_binom (int NN, int u, int v, double p01,double p10,double p11);
double biv_binom2(int NN_i,int NN_j, int k, int u, int v, double p01,double p10,double p11);
double log_biv2gauss(int *cormod, double dij,double *par, double data1, double data2, int first,int second);
double biv_Poisson(double corr,int r, int t, double mean_i, double mean_j);
double appellF4(double a,double b,double c,double d,double x,double y);
double biv_PoissonGamma(double corr,int r, int t, double mean_i, double mean_j, double a);
double biv_PoissonZIP(double corr,int r, int t, double mean_i, double mean_j,double mup,double nugget1,double nugget2);
double biv_PoissonGammaZIP(double corr,int r, int t, double mean_i, double mean_j,double mup,double nugget1,double nugget2,double shape);
double biv_binomnegZINB(int N,double corr,int r, int t, double mean_i, double mean_j,double nugget1,double nugget2,double mup);
double biv_wrapped(double alfa,double u, double v, double mi, double mj, double nugget,double sill,double corr);
double biv_Weibull(double corr,double zi,double zj,double mui, double muj, double shape);
double biv_Weibull2(double rho12,double zi,double zj,double mi,double mj, double shape1,double shape2);
double biv_gamma(double corr,double zi,double zj,double mui, double muj, double shape);
double biv_gamma2(double corr,double zi,double zj,double mui, double muj, double shape);
double biv_gamma_gen(double corr,double zi,double zj,double mui, double muj, double shape,double n);
double biv_Kumara(double rho,double zi,double zj,double ai,double aj,double shape1,double shape2,double min,double max);
double biv_Kumara2(double rho,double zi,double zj,double ai,double aj,double shape1,double shape2,double min,double  max);
double biv_beta(double rho,double zi,double zj,double ai,double aj,double shape1,double shape2,double min,double max);
//double log_biv_binom (int NN, double u, double v, double psm,double psj);
double biv_LogLogistic(double corr,double zi,double zj,double mui, double muj, double shape);
double biv_Logistic(double corr,double zi,double zj,double mui, double muj, double sill);
double biv_binomneg (int NN, int u, int v, double p01,double p10,double p11);
double biv_binegbinary(int NN, int u, int v,double pu,double pv, double p11);
double biv_binom222(int n1,int n2, int u, int v, double p01,double p10,double p11);
double bin_aux(int a,int NN,int u,int v,double p1, double p2,double p11);
double aux_biv_binomneg (int NN, int u, int v, double x,double y,double p11);
double aux_biv_binomneg_simple(int NN, int u, double p01,double p10,double p11);
double aux_euv_binomneg (int N, double p1,double p2,double p11);
double aux_biv_binom(int n1,int n2, int u, int v,double p01,double p10,double p11);
double corr_binomneg (int N, double p1,double p2,double p11);
double psi(int i, int j, double p1, double p2, double p12,double**cache);
double cov_binom_neg(int m,double p11,double p1, double p2);
double biv_poisbin (int NN,  int u, int v, double p01,double p10,double p11);
double biv_poisbinneg(int NN, int u, int v, double p01,double p10,double p11);
double biv_two_piece_bimodal(double rho,double zi,double zj,double sill,double nuu,double delta,double eta,
             double p11,double mui,double muj);
double cor_pois(double rho,double mi,double mj);
double e_n(int k,double x);
double biv_skew(double corr,double zi,double zj,double mi,double mj,double vari,double skew,double nugget);
double log_biv_skewlaplace(double rho,double z1,double z2,double m1,double m2,double sill,double p);
double biv_sinh(double corr,double zi,double zj,double mi,double mj,double skew,double tail,double vari);
//bivariate skew gaussian bivariate  distribution
double biv_skew2(double corr,double zi,double zj,double vari1,double vari2,double rho ,
         double skew1,double skew2);

double biv_Mis_PoissonZIP(double corr,double data_i, double data_j,
                             double mean_i, double mean_j,double mup,double nugget1,double nugget2);
double triv_skew(double x,double c_0i,double c_0j, double rho,double data_i,double data_j,double *nuis);

double compute_biv_norm_density(double d1, double d2, double mui, double muj, 
                                             double vvi, double vvj, double corr1);

double LambertW(double z);
double inverse_lamb(double x,double tail);
double dbnorm(double x_i,double x_j,double mean_i,double mean_j,double sill,double corr);
double biv_tukey_h(double data_i, double data_j, double mean_i, double mean_j, double tail, double sill, double corr);
double biv_tukey_hh(double corr,double data_i,double data_j,double mui,double muj,
    double sill,double hl,double hr);
double cond_exp_skew(double c_0i,double c_0j,double rho, double data_i,double data_j,double *nuis);
double cond_exp_bin(int *cormod,double data_i,double data_j,double lags_i,double lags_j,double lags,double *nuis,double *par,double psm);
double biv_cop(double rho,int type_cop,int cond,
             double z1,double z2,double mu1,double mu2,double *nuis,int model, int NN1,int NN2);
double marg_binom(int n,double x,double p);
double marg_binomneg(int n,int x,double p);
double marg_pois(int n,double x,double p);
double marg_geom(int x,double p);
double corr_pois_gen(double corr,double mean_i, double mean_j, double a);
double corr_pois_s(double rho,double mi);
double corr_pois(double rho,double mi,double mj);
double corr_pois_gen(double corr,double mean_i, double mean_j, double a);
double corr_tukeygh(double rho,double eta,double tail);
double corr_skewt(double corr,double df,double skew);
double corr_pois1(double rho,double lambda1,double lambda2);
double marg_p(double categ_0,double psm,int *model,int n);

double CheckCor(int *cormod, double *par);


/*
void spectraldensityC(double u,int model,int d,int L,double *f,double *av,double *Cv,double *nu1v,double *nu2v);
void extraer(double *coord,int sequen1,double *sub_coord,int fila,int col, int d);
void rellenar_indice(int *index,int inicio, int final,int largo);
void u_index_extraer(double *u_index,double *u, int *index,int largo,int d,int filas);
void mult_mat(double *z, double *x, int xrows, int xcols, double *y, int yrows, int ycols);
void tcrossprod(double *z, double *x,  int xrows, int xcols, double *y, int yrows, int ycols);
void mult_x_cons(double *x, double cte,int largo);
void sumar_matrices(double *x0, double *x,double *y,int largo);
void restar_matrices(double *x0, double *x,double *y,int largo);
void cos_vec(double *x_cos,double *x,int largo);
void sen_vec(double *x_sen,double *x,int largo);
void llenar_simu(double *x,double *simu, int N,int *P, int m);
void extraer_col(int inicio, int final,double *x_original,double *x);
void llenar_simu1(double *simu1,double *simu,int *m,int *P,int *N,int lim, int i,double *L1);
void C_tcrossprod(Rcomplex *z, Rcomplex *x,  int xrows, int xcols, Rcomplex *y, int yrows, int ycols);
void C_mult_mat(Rcomplex *z, Rcomplex *x, int xrows, int xcols, Rcomplex *y, int yrows, int ycols);
*/


void Comp_supp(double *c_supp,int *cormod, double h,double u, double *par);
double CorFct(int *cormod, double h, double u, double *par, int c11, int c22);
double CorFunCauchy(double lag, double power2, double scale);
double CorFunDagum(double lag, double power1, double power2, double scale);
double CorFunGenCauchy(double lag, double power1, double power2, double scale);
double CorFunGenCauchy2(double lag, double power1, double power2, double scale);
double CorFunWitMatCau(double h, double scale12,double smo12);
double Shkarofski(double lag, double a,double b, double k);
double CorFunSmoke(double h, double  scale,double  smooth);
double CorFunGenWitMatCau(double h, double scale,  double smoo,double beta);
double CorFunSferical(double lag, double scale);
double CorFunStable(double lag, double power, double scale);
double CorFunWave(double lag, double scale);
double CorFunWitMat(double lag, double scale, double smooth);
double CorFunWitMathole(double lag, double scale, double smooth,double R_power1);
//double onef2(double a, double b, double c, double x, double *err);
double Corschoenberg(double lag,double scale);
double CorFunWitMat1(double lag, double scale, double smooth);
double CorFunBohman(double lag,double scale);
double CorFunW0(double h,double scale,double power);
double CorFunW1(double h,double scale,double power);
double CorFunW2(double h,double scale,double power);
double CorFunW_gen(double h, double power1, double smooth, double scale);
double CorFunW_genhole(double lag,double R_power1,double smooth,double scale,double kk);
double CorFunHyperg2(double lag,double R_power,double R_power1,double smooth,double scale);
double CorFunHyperg(double lag,double R_power,double smooth,double scale);
double CorKummer(double lag,double R_power,double smooth,double scale);
double CorFunWend1(double lag,double scale);
double CorFunWend2(double lag,double scale);
double CorFunWend3(double lag,double scale);
double CorFunWend4(double lag,double scale);
double CorFunWend5(double lag,double scale);
double CorFunWendhole3(double lag,double scale);
double CorFunWendhole2(double lag,double scale);
double CorFunWendhole1(double lag,double scale);
double CorFunWendhole(double lag,double scale);
double CorFunWend0_tap(double lag,double scale,double smoo);
double CorFunWend1_tap(double lag,double scale,double smoo);
double CorFunWend2_tap(double lag,double scale,double smoo);
double Matern_Matern_nosep(double h, double u,
                           double scale_s, double scale_t,
                           double smooth_s, double smooth_t,
                           double sep);
double GenWend_GenWend_nosep(double h, double u,
                           double scale_s, double scale_t,
                            double power_s, double power_t,
                           double smooth_s, double smooth_t,
                           double sep);



void GradCorrFct(double rho, int *cormod, double eps, int *flag,
         double *grad, double h, double u, int c11, int c22, double *par);
void GradVarioFct(double vario, int *cormod, double *eps, int *flag,
          double *grad, double lag, double *par, double tsep);
void TapVectCorrelation(double *rho,int *cormod,double *tdists,int *ntdists,double *nuis,double *par);




double Variogram(int *cormod, double h, double u, double nugget, double var, double *par);

double VarioFct(int *cormod, double h, double *par, double u);

double VarioDobStable(double lag, double power_s, double power_t, double scale_s, double scale_t, double tsep);

double VarioGCauchy(double lag, double power1, double power2, double scale);


/*----------------------------------------------------------------
 Function for matrix manipulation
 ---------------------------------------------------------*/

void CoFactor(double **a,int n,double **b);
void Transpose(double **a,int n,double k);
void Matrix_prod(double **a,double **b,double **c,int n);
void Matrix_prod_vec(double **a,double *b,double *c,int n);
double Determinant(double **a,int n);
double QFORM(double **A,double *x,double *y,int n);
double QFORM2(double **A,double *x,double *y,int n, int m);
double Trace(double **A,int n);
void lubksb(double **a, int n, int *indx, double *b);
void ludcmp(double **a, int n, int *indx, double *dd);







// 3)
/*----------------------------------------------------------------
File name: Distributions.c
Description: procedures for the computation of useful distributions
Start
 ---------------------------------------------------------------*/
double biv_two_pieceTukeyh(double rho,double zi,double zj,double sill,double eta,double tail,double p11,double mui,double muj);
double cdf_norm(double lim1,double lim2,double a11,double a12);
double cdf_norm2(double lim1,double lim2,double a11,double a12, double a22);

double log_biv_Norm(double corr,double zi,double zj,double mi,double mj,double vari, double nugget);

double d2norm(double x, double y, double rho);
double d22norm(double x, double y,double v11,double v22,double v12);
double d2lognorm(double x, double y, double sill,double nugget, double mux,double muy,double rho);

double dNnorm(int N,double **M, double *dat);

double int_pt(double x, double df);
double kummer(double a, double b,double c);

double int_gen(double x,double mu, double alpha,double lag,double supp);
double int_onef2(double x,double a, double b1,double b2,double y);
double int_hyp(double x,double a, double b,double c,double z);
double int_gen_hyp(double x,double a, double b,double z,double c);
void integr_pt(double *x, int n, void *ex);
void integr_hyp(double *x, int n, void *ex);
void integr_gen_hyp(double *x, int n, void *ex);
void integr_onef2(double *x, int n, void *ex);
double HyperG_integral(double x, double *param);
double IntHyp(double x, double *param);
void integr_gen(double *x, int n, void *ex);

double int_gen_skew(double x,double data_i, double data_j,double c_0i,double c_0j,double rho,double *nuis);
void integr_gen_skew(double *x, int n, void *ex);
double cond_exp_skew(double c_0i,double c_0j,double rho, double data_i,double data_j,double *nuis);

double  wendintegral(double x, double *param);
double onef2integral(double x, double *param);
double pbnorm(int *cormod, double h, double u, double lim1, double lim2, double nugget, double var,double *par, double thr);
double phalf_gauss (double z);
double pbnorm22(double lim1,double lim2,double corr);
double bvnmvn_optimized(const double *lower, const double *upper, 
                          const int *infin, double correl);
double pblogi22(double lim1,double lim2,double corr);
double ptnorm(int which,int *cormod, double h0,double h1,double h2, double u0, double u1,double u2, 
                 double *nuis, double *par, double thr);
double pbhalf_gauss (double zi,double zj,double rho,double nugget);
double pnorm_two_piece(double x, double eta);
double pbnorm_two_piece( int *cormod, double h, double u, 
    double xi, double xj, double nugget, double var,double eta,double *par);




// 4)
/*----------------------------------------------------------------
File name: Godambe.c
Description: procedures for the computation of the Godambe matrix
Start
 ---------------------------------------------------------------*/





void Sens_Cond_Gauss(double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis, double *nuis, int *np,
             int *npar, int *nparc, double *parcor, double *score, double *sensmat,int *weigthed);

void Sens_Cond_Gauss_st(double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis, double *nuis, int *np,
            int *npar, int *nparc, double *parcor, double *score, double *sensmat,int *weigthed);

void Sens_Cond_Gauss_biv(double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis, double *nuis, int *np,
                         int *npar, int *nparc, double *parcor, double *score, double *sensmat,int *weigthed);


void Sens_Cond_Gauss_ij(double rho, int *flag, double *gradcor, int *npar,
            int *nparc, double *par, double *sensmat);

void Sens_Cond_Gauss_biv_ij(double *gradcorttii,double *gradcorvvii,double *gradcorvtii,double *gradcortvii ,
                            double *gradcorttij ,double *gradcorvvij, double *gradcorvtij,double *gradcortvij,
                            double **inverse,int *flag,int *npar, int * nparc, double *par,int N,double *sens);

void Sens_Diff_Gauss(double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis,
             double *nuis, int *np,int *npar, int *nparc, double *parcor,double *score, double *sensmat,int *weigthed);

void Sens_Diff_Gauss_st(double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis,
            double *nuis, int *np,int *npar, int *nparc, double *parcor, double *score, double *sensmat,int *weigthed);

void Sens_Diff_Gauss_ij(double *gradient, int *npar, double *sensmat,double weigths);


void Sens_Pair(double *betas,double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis,double *NN,
         double *nuis, int *np, int *nbetas,int *npar,  int *nparc,int *nparcT,double *mean, int *model, double *parcor,double *score,  
         double *sensmat,int *weigthed,double *Z, int *type_lik);

void Sens_Pair_st(double *betas,double *coordx, double *coordy, double *coordt, int *cormod, double *data, 
         double *eps, int *flagcor, int *flagnuis, double *NN,double *nuis, int *np,
      int *nbetas, int *npar,int *nparc,int *nparcT, double *mean, int *model,
            double *parcor, double *score, double *sensmat,  int *weigthed,double *Z, int *ns, int *NS,int *type_lik);

void Sens_Pair_biv(double *betas,double *coordx, double *coordy, double *coordt, int *cormod, double *data, double *eps, int *flagcor, int *flagnuis,
                         double *NN, double *nuis, int *np,int *npar, int *nparc,int *nparcT, double *mean,int *mode,
                         double *parcor, double *score, double *sens,int *weigthed,double *Z, int *ns, int *NS,int *type_lik);

void Sens_Pair_Gauss_ij(double rho, int *flag, double *gradcor, int *npar, int nbetas,
      int *nparc, double *par, double *sensmat, double *Xi, double *Xj);

void Sens_Pair_Gauss_biv_ij(double rhott,double rhotv,double rhovt,double rhovv,double *gradcortt,double *gradcortv,double *gradcorvt,double *gradcorvv,
                            int *flag, int *npar,int *nparc, double *par, double *sensmat);

void Sensitivity(double *betas,int *biv,double *coordx,double *coordy,double *coordt,int *cormod,  double *data, double *eps, int *flagcor, int *flagnuis, int *like,
     double *mean, int *model, double *NN,int *nbetas, int *npar, int *nparc,int *nparcT, double *parcor, double *nuis, int *np,double *score,
     double *sensmat, int *spt, int *type_lik,int *weigthed,double *Z,int *ns,int *NS);
 

void Vari_SubSamp(double *betas,double *coordx, double *coordy, double *coordt,int *cormod, double *data,
                  int *dst,double *eps, int *flagcor, int *flagnuis, int *grid,
                  int *like, double *mean,int *model, double *NN, int *nbetas,int *npar, int *nparc,int *nparcT, double *nuis, int *np,
                  double *parcor,  int *type_lik, double *varimat,
                  double *winc, double *winstp,int *weigthed,double *Z);
void Vari_SubSamp_biv(double *betas,double *coordx, double *coordy, double *coordt,int *cormod, double *data,
                  int *dst,double *eps, int *flagcor, int *flagnuis, int *grid,
                  int *like, int *model, double *NN,int *npar, int *nparc,int *nparcT, double *nuis, int *np,
                  double *parcor,  int *type_lik, double *varimat,
                  double *winc, double *winstp,int *weigthed,double *Z,int *ns,int *NS);

void Vari_SubSamp_st2(double *betas,double *coordx, double *coordy, double *coordt, int *cormod, double *data, int *dst, double *eps, int *flagcor,
                   int *flagnuis,int *like,double *mean,int *model,double *NN,int *nbetas,int *npar, int *nparc,int *nparcT, double *nuis,int *np, double *parcor,
                   int *type_lik,double *varimat, double *winc, double *winstp,double *winc_t,double *winstp_t,int *weigthed,double *Z,int *ns,int *NS);
void cumvec(int *ns,int *res,int len);
void Rep(double *coordt,int *ns, double *res);
/*----------------------------------------------------------------*/

double mij(double qij, double w, double pij, double p);

double nij(double qij, double w, double pij, double p);

/*----------------------------------------------------------------*/


/*----------------------------------------------------------------
File name: Utility.c
Description: procedures for the computation of useful quantities.
Start
 ---------------------------------------------------------------*/

//void DeleteGlobalVar();

void RangeDist(double *max, double *min);

double fac(int x,int j);

double logfac(int n);

/*for bivariate t distributions*/
double Poch(int q,int n);
double biv_T(double rho,double zi,double zj,double nuu,double nugget);
double biv_two_pieceT(double rho,double zi,double zj,double sill,double nuu,double eta,double p11,
  double mui,double muj,double nugget);
/**********************************************/
double biv_half_Gauss(double rho,double zi,double zj);
double biv_two_pieceGaussian(double rho,double zi,double zj,double sill,double eta,double p11,
  double mui,double muj);



double stirling(double x);

double dist(int type_dist,double coordx,double locx,double coordy,double locy,double coordz,double locz, double radius); 

double Dist_geodesic(double loni, double lati, double lonj, double latj,double radius);

double Dist_chordal(double loni, double lati, double lonj, double latj,double radius);


int is_equal(double val1, double val2);

double Maxima(double *x, int *size);
double Maxima_i(int *x, int size);

double Minima(double *x, int *size);





void Range(double *x, double *ran, int *size);

void Seq(double *x, int len, double *res);

void SeqStep(double *x, int len, double step, double *res);

void SetSampling(double *coordx, double *coordy, double *data, int n, int *npts, int nbetas,
     double *scoordx, double *scoordy, double *sdata, double xmax,
     double xmin, double ymax, double ymin, double **sX,double **X);


void SetSampling_biv(double *coordx, double *coordy, double *data, int n, int *npts,
                     double *scoordx, double *scoordy, double *sdata, double xmax,
                     double xmin, double ymax, double ymin);

void SetSampling_st(double *data,double *sdata, int *ncoordss,int *ntime, int nbetas,
        int wint,int k, double **sX,double **X);

void SetSampling_s(double *coordx, double *coordy, double *data, int *npts, int nbetas,
                   double *scoordx, double *scoordy, double *sdata, double xmax,
                   double xmin, double ymax, double ymin,double **sX,double **X,int *ns,int *NS, int *NS_sub, double *res_sub, double *coordt,int *ns_sub);

void SetSampling_t(double *data,double *sdata, int nbetas,int npts,
                   int nt,int wint,int k,double **sX,double **X,int *ns_sub,int *NS_sub,int nsub_t, int *ntimeS, double *s2cx, double *s2cy, double *scoordx, double *scoordy);







void Space_Dist(double *coordx,double *coordy,double *coordz,int *ia,int *idx,
        int *ismal,int *ja,int *colidx,int *rowidx ,double thres);


void SpaceTime_Dist(double *coordx,double *coordy,double *coordz,double *coordt,int *ia,int *idx,int *ismal,int *ja,
                    int *tapmodel,int *ns, int  *NS,int *colidx,int *rowidx ,double *thres,double *thret);

void SpaceBiv_Dist(double *coordx,double *coordy,double *coordz,double *coordt,int *ia,int *idx,int *ismal,int *ja,
                    int *tapmodel,int *ns, int  *NS,int *colidx,int *rowidx ,double *thres);
/*----------------------------------------------------------------
File name: Utility.c
Description: procedures for the computation of useful quantities.
End
 ---------------------------------------------------------------*/

double log_pochhammer(double a, int n);
double hypergeometric_1F2(double a, double b, double c, double x, double tol);

double biv_unif_CopulaGauss(double dat1,double dat2,double rho);
double biv_unif_CopulaClayton(double dat1,double dat2,double rho,double nu);
double biv_unif_CopulaSkewGauss(double dat1, double dat2, double rho,double alpha);

double lgam_sgn(double x, int *sign);
//double lgam(double x);


double hypergeo(double a,double b,double c,double x);
double hypergeo_sem(double a,double b,double c,double x);

double polevl(double x, const double coef[], int N);
double p1evl(double x, const double coef[], int N);


// START hyperg.c
//static double hy1f1p(double a, double b, double x, double *acanc);
//static double hy1f1a(double a, double b, double x, double *acanc);

//static double hyp2f0(double a, double b, double x, int type, double *err);
double hyperg(double a, double b, double x);
double hypergeo2(double a, double b, double c, double x);
double hyper_2f1(double a, double b, double c, double z) ;



// END hyperg.c









double DMat_biv_smo1(double h,double eps,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                     double smoo11, double smoo22,double smoo12, double col,int c11,int c22);

double DMat_biv_smo12(double h,double eps,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                      double smoo11, double smoo22,double smoo12, double col,int c11,int c22);

double DMat_biv_smo2(double h,double eps,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                     double smoo11, double smoo22,double smoo12, double col,int c11,int c22);


double DWen1_biv_scale1_contr(double h,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                              double smoo11, double smoo22,double smoo12, double col,int c11,int c22);

double DWen1_biv_scale2_contr(double h,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                              double smoo11, double smoo22,double smoo12, double col,int c11,int c22);


double DWen1_biv_smo1(double h,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                      double smoo11, double smoo22,double smoo12, double col,int c11,int c22);


double DWen1_biv_smo12(double h,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                       double smoo11, double smoo22,double smoo12, double col,int c11,int c22);
double DWen1_biv_smo2(double h,double var11,double var22,double nug11,double nug22, double scale11,double scale22, double scale12,
                      double smoo11, double smoo22,double smoo12, double col,int c11,int c22);
// ******** END: CorrelationFunction ******

// ******** ST: Distributions ******

int is_nonpos_int(double x);
double poch(double a, double m);
//double log_hyp1F1_reg(int n,int m,double z);
double log_regularized1F1(int n, int m,double z) ;
double aprox_reg_1F1(int n, int m,double z) ;

double try(int m, double b,double z);
double Phi(double x);
double Phi2diag( double x, double a, double px, double pxs );

double Phi2help( double x, double y, double rho );

double Phi2( double x, double y, double rho );

//double igam2(int n,double x);

double igam_fac(double a, double x);
double biv_chisqu2(double corr,double zi,double zj, double shape);


double asy_log_besselI(double z,double nu);

//double corrPGs(double corr,double mean,double a);

double CorrPGns(double corr,double mean_i, double mean_j, double a);
double biv_Norm(double corr,double zi,double zj,double mi,double mj,double vari1,double vari2, double nugget);


double p3norm(int *cormod, double h0,double h1,double h2, double u0, double u1,double u2,
              double *nuis, double *par);

double aprox(int k,double a, double b) ;
double aprox1(double a) ;

double appellF42211(double x,double y);

double appellF4_mod(double nu,double rho,double x,double y,double nugget);

double biv_Unif(double rho,double ui,double uj);

double biv_half_Tukeyh(double rho,double ti,double tj,double tail);
double  binomialCoeff(int n, int k) ;


double Prt(double corr,int r, int t, double mean_i, double mean_j);

double Prr(double corr,int r, int t, double mean_i, double mean_j);

double Pr0(double corr,int r, int t, double mean_i, double mean_j);

double P00(double corr,int r, int t, double mean_i, double mean_j);

double PG00(double corr,int r, int t, double mean_i, double mean_j, double a);

double PGrr(double corr,int r, int t, double mean_i, double mean_j, double a);

double PGr0(double corr,int r, int t, double mean_i, double mean_j, double a);

double PGrt(double corr,int r, int t, double mean_i, double mean_j, double a);

double int_kuma(double x,double eta, double gam,double k,double m);

double kumaintegral(double *param);

double mean_kuma(double eta,double gam);

double var_kuma(double eta, double gam);
double corr_kuma(double rho,double eta,double gam);
double cdf_kuma(double y,double a, double b);

double pdf_kuma(double y,double a, double b);

// ******** END: Distributions ******


// ******** ST: TB ******

// ******** END: TB ******


// ******** ST: Utility ******
double qnorm55(double p, double mu, double sigma, int lower_tail, int log_p);

// ******** END: Utility ******

void Maxima_Minima_dist(double *res,double *coordx,double *coordy,double *coordz,int *nsize,int *type_dist,double *radius);
