% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgreen.R
\name{launch_green}
\alias{launch_green}
\title{GREEN execution}
\usage{
launch_green(
  catch_data,
  annual_data,
  alpha_p,
  alpha_l,
  sd_coef,
  loc_years,
  atm_coeff = 0.38
)
}
\arguments{
\item{catch_data}{data frame. Definition of the topological sequence of
catchments.}

\item{annual_data}{data frame. Sources of nutrient for each year and
catchments.}

\item{alpha_p}{numeric. First model parameter, the basin retention
coefficient.}

\item{alpha_l}{numeric. Second model parameter, the river retention
coefficient.}

\item{sd_coef}{numeric. Third model parameter, fraction of domestic diffuse
sources that reaches the stream network.}

\item{loc_years}{integer. Years in which the model should be executed.}

\item{atm_coeff}{numeric. It defines the atmospheric attenuation coefficient.}
}
\value{
One object, a data frame
}
\description{
Applies the model GREEN (Grizzetti et al.
[@grizzetti2012changes, @grizzetti2021eu]) to a basin and returns annual
nutrient (nitrogen or phosphorus) load for all catchments in the basin
}
\keyword{internal}
