% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\title{Calculate Coverage of Daily Summaries}
\usage{
coverage(x, graph = FALSE)
}
\arguments{
\item{x}{Object of class \code{ghcn_daily}. See \code{\link[=daily]{daily()}} for details.}

\item{graph}{Logical, if to show a graph of annual coverage.}
}
\value{
A table with coverage.
}
\description{
\code{coverage()} calculates the temporal coverage of the time series.
See also \code{\link[=monthly_coverage]{monthly_coverage()}}, \code{\link[=annual_coverage]{annual_coverage()}}, and \code{\link[=period_coverage]{period_coverage()}}.
}
\details{
Returns a table with:
\itemize{
\item mothly_coverage The proportion of the days with records in the month
\item annual_coverage The proportion of the days with records in the year
\item annual_coverage The proportion of the years with records in the reference period
}
}
\examples{
cleaned <- remove_flagged(CA003076680)
cover <- coverage(cleaned)
cover[cover$month == 1, ]
}
