% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_tally_list.R
\name{fe_tally_list}
\alias{fe_tally_list}
\title{User Friendly Construction of an \strong{fe_tally_list} Object from a List of
Data Frames}
\usage{
fe_tally_list(
  x,
  stand_id = "my_tally_list",
  tree_count_name = "tree_count",
  class_def_name = "class_definition",
  area_ha_name = "area_ha",
  size_class_col,
  tree_nr_col,
  species_id_col,
  count_col,
  class_type_col,
  class_min_col,
  class_max_col
)
}
\arguments{
\item{x}{named list of two or three data frames to be coerced into the goal
object. One data frame must contain the tree counts data}

\item{stand_id}{arbitrary id of the stand (\code{character}, default:
"my_tally_list")}

\item{tree_count_name}{name of the data frame in \code{x} that contains the
tree data counting (default: "tree_count")}

\item{class_def_name}{name of the column in the trees data frame which
provides the definition of the counting classes (default: "class_definition")}

\item{area_ha_name}{name of the column in the trees data frame which provides
each tree's representation number per ha.}

\item{size_class_col}{description}

\item{tree_nr_col}{description}

\item{species_id_col}{description}

\item{count_col}{description}

\item{class_type_col}{description}

\item{class_min_col}{description}

\item{class_max_col}{description}
}
\value{
If the user input allows to construct a well-defined
\code{fe_tally_list} object, this object will be returned. If not, the
function will terminate with an error.
}
\description{
\code{fe_tally_list()} provides a user-friendly interface for the
constructor \code{\link{new_fe_tally_list}}. While the constructor does
not prevent users from creating malformed \code{fe_tally_list} objects,
\code{fe_tally_list} does everything to achieve a well-defined object
mostly based on an initial list of data.frames that might be, e.g. drawn out
of a user's own data base.
}
\details{
The input object \code{x} to \code{fe_tally_list} must be a list that
comprises two data frame(s):
\itemize{ \item a data frame containing the tree counts per class.
This data frame must contain a a minimum set of columns (Nr, size_class, N,
species.

\item a data frame that contains information about the class definition, }
}
\keyword{internal}
