% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_example_stands.R
\docType{data}
\name{example_data}
\alias{example_data}
\alias{norway_spruce_1_raw}
\alias{norway_spruce_1_fe_stand}
\alias{european_beech_1_raw}
\alias{european_beech_1_fe_stand}
\alias{spruce_beech_1_raw}
\alias{spruce_beech_1_fe_stand}
\alias{selection_forest_1_raw}
\alias{selection_forest_1_fe_stand}
\alias{mm_forest_1_raw}
\alias{mm_forest_1_fe_stand_spatial}
\alias{spruce_pine_ccircle_raw}
\alias{spruce_pine_ccircle_spatial}
\alias{spruce_pine_ccircle_spatial_notrees}
\title{Example Stands}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 498 rows and 8 columns.

An object of class \code{fe_stand} of length 4.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 268 rows and 8 columns.

An object of class \code{fe_stand} of length 4.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 225 rows and 8 columns.

An object of class \code{fe_stand} of length 4.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 283 rows and 7 columns.

An object of class \code{fe_stand} of length 4.

An object of class \code{list} of length 5.

An object of class \code{fe_stand_spatial} (inherits from \code{fe_stand}) of length 6.

An object of class \code{list} of length 8.

An object of class \code{fe_ccircle_spatial} (inherits from \code{fe_stand_spatial}, \code{fe_stand}) of length 6.

An object of class \code{fe_ccircle_spatial_notrees} (inherits from \code{fe_ccircle_spatial}, \code{fe_stand_spatial}, \code{fe_stand}) of length 6.
}
\usage{
norway_spruce_1_raw

norway_spruce_1_fe_stand

european_beech_1_raw

european_beech_1_fe_stand

spruce_beech_1_raw

spruce_beech_1_fe_stand

selection_forest_1_raw

selection_forest_1_fe_stand

mm_forest_1_raw

mm_forest_1_fe_stand_spatial

spruce_pine_ccircle_raw

spruce_pine_ccircle_spatial

spruce_pine_ccircle_spatial_notrees
}
\description{
\strong{ForestelementsR} comes with five example stands that exist each in a 'raw'
format that could have been taken from a user data base, and one of the
package's specific stand object classes (\strong{fe_stand}, \strong{fe_stand_spatial},
,\strong{fe_ccircle_spatial}). Four of the example stands correspond to the
\strong{fe_stand} class, one to the
\strong{fe_stand_spatial}  and one to \strong{fe_ccircle_spatial}class.
The \strong{fe_stand}, \strong{fe_stand_spatial} and  \strong{fe_ccircle_spatial} objects
have been constructed from the raw data using the functions
\code{\link{fe_stand}},  \code{\link{fe_stand_spatial}} and
\code{\link{fe_ccircle_spatial}} (see the examples section of the functions'
documentation).

\describe{
\item{\strong{fe_stand} compatible examples:}{
The first stand is a 53 years-old Norway spruce stand, the second one
a 79 year old European beech stand, the third an even-aged mixed stand of
Norway spruce and European beech (75 and 88 years, respectively). The
fourth stand is a selection forest comprising the species Norway spruce,
silver fir, European beech, and sycamore. All these stands have an area
of 0.49 ha. The raw data (see name suffix) are data.frames (tibbles)
comprising the following columns
\describe{
\item{\code{stand}}{Name of the stand}
\item{\code{species}}{Integer numbers following the
\code{TUM_WWK_short} convention}
\item{\code{no}}{Tree id}
\item{\code{age}}{Tree age (i.e. stand age, in these examples) in
years; note that the selection forest data do not provide age
information, as this is usually not available in practice and mostly
not meaningful for this forest type}
\item{\code{d}}{Breast height (1.3 m) stem diameter in cm}
\item{\code{h}}{Tree height in m}
\item{\code{hcb}}{Crown base height in m}
\item{\code{crad}}{Crown radius in m}
}
The fe_stand objects (see name suffix) resulted from converting the
raw data with \code{\link{fe_stand}}
}
\item{\strong{fe_stand_spatial} compatible example:}{
\strong{mm_forest_1_raw} represents raw data from a research plot in a mixed
mountain forest that has been surveyed several times.
\strong{mm_forest_1_fe_stand_spatial} is the representation of this plot as an
object of class \code{\link{fe_stand_spatial}}
}
\item{\strong{fe_ccircle_spatial} compatible examples}{
\strong{spruce_pine_ccircle_raw} represents raw data that could come from a
typical inventory plot of the Bavarian State Forest, while
\strong{spruce_pine_ccircle_spatial} is an object of class
\code{\link{fe_ccircle_spatial}}.
}
}
}
\keyword{datasets}
