% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crown_diameter_silva.R
\name{crown_diameter_silva}
\alias{crown_diameter_silva}
\title{Estimate a tree's crown diameter}
\usage{
crown_diameter_silva(species_id, dbh_cm, height_m)
}
\arguments{
\item{species_id}{Vector of species id's following the \emph{tum_wwk_short}
species coding. Ideally, these species_id's are provided as a
\code{fe_species_tum_wwk_short} object. If they are provided as another
object, \code{crown_diameter_silva} will make an attempt to convert them.
If this is not possible, the function will terminate with an error. The
species id's can also be provided as numeric values (\code{double} or
\code{integer}) or \code{character}. These will be internally converted to
\code{fe_species_tum_wwk_short}. If this fails (i.e. the user provided
species codes not defined in the \emph{tum_wwk_short} coding), an error is
thrown and the function terminates.}

\item{dbh_cm}{Vector of tree dbh values in cm (dbh = stem diameter at breast
height, i.e. 1.3 m)}

\item{height_m}{Vector of tree height values in m}
}
\value{
An estimate of the tree's diameter of the crown at its greatest
lateral extension in m.
}
\description{
This function can be used for estimating a tree's crown diameter, given its
species, its stem diameter at breast height, and its total height. This is
the crown diameter function which is implemented in the forest growth
simulator SILVA \insertCite{pretzsch_single_2002}{ForestElementsR}. The crown
diameter in this context is defined as the average diameter of the crown at
its greatest lateral extension. The crown diameter equations are
available for exactly the species (groups) defined in the coding
\emph{tum_wwk_short}. If they are called with another species coding supported by
the package \strong{ForestElementsR}, \code{crown_diameter_silva} will attempt to
convert them accordingly.
}
\examples{
# Estimate the crown diameter of a Scots pine with a stem diameter
# at breast height of 45.2 cm and a total height of 29.2 m:
crown_diameter_silva(
  species_id = "3",    # will be internally converted to tum_wwk_short
  dbh_cm = 45.2,
  height_m = 29.2
) # 6.1 m (rounded)

# Crown diameter estimate for a European beech with
# the same height and diameter:
crown_diameter_silva(
  species_id = "5",   # will be internally converted to tum_wwk_short
  dbh_cm = 45.2,
  height_m = 29.2
) # 9.6 m (rounded)

# Run vectorized
spec <- mm_forest_1_fe_stand_spatial$trees$species_id
d <- mm_forest_1_fe_stand_spatial$trees$dbh_cm
h <- mm_forest_1_fe_stand_spatial$trees$height_m
crown_diameter_silva(spec, d, h)

}
\references{
\insertAllCited{}
}
